/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           Kamera.c
 *  Filetyp:            Modul
 ********************************************************************************
 *  Modulname:
 *  Version:            1.0
 *  letzte Aenderung:
 *  Autor:              Andreas
 *  Status:             finished, only bugs will be fixed
 *
 *  imp. Bezeichner:
 *
 *  exp. Bezeichner:
 *
 *  Beschreibung:
 *  -------------
 *
 *  Fehler:
 *  -------
 *
 *  Versionsgeschichte:
 *  -------------------
 *   19.01.93: Einbringen der geforderten Dialogbutons, wobei allerdings nur
 *             eine Funktion bisher unterst"utzt wird: Ende.
 *   26.01.93: Weitere Funktionen wie Verschieben der Kamera wird unterst"utzt.
 *             Es wurde ein neuer Button eingef"ugt, der erlaubt die zwischen-
 *             zeitlichen "Anderungen r"uckg"angig zu machen und die Kamera zu
 *             verlassen.
 *   01.02.93: Jetzt kann man die Kamera auch um alle Achsen rotieren.
 *   09.03.93: Undo aller Translationen und Rotationen m"oglich.
 *   03.04.93: Default-Werte Button kam hinzu, die Kamera sitzt inzwischen auch 
 *             nicht mehr direkt auf der Z-Achse.
 *  -24.06.93: Kamera kann nun auch an einem K"orper befestigt sein.
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Repeater.h>

#include "Welt.h"


/********************************************************************************
 *  Importierte Funktionen aus unterschiedlichen 'Modulen'.
 ********************************************************************************/
   extern  void Q_MUL( TQuaternion, TQuaternion, TQuaternion );
   extern  void AnzeigeAnimation( Widget, TKamera, TZustand *, int );


/********************************************************************************
 *  Importierte Bezeichner (global definiert)
 ********************************************************************************/
extern Widget topLevel, KW_Shell, AW_Animation;
extern TWelt *aktuelleWelt;
extern TKamera AnimKamera; 
extern TBoolean AnimKameraOpen;
extern TQuaternion CRotXP, CRotXM, CRotYP, CRotYM, CRotZP, CRotZM;
extern int KoordAnAus, KoerperKoordAnAus, KraefteAnAus, dreiD;
extern Pixmap BRotXP, BRotXM, BRotYP, BRotYM, BRotZP, BRotZM;
extern Pixmap BMovXP, BMovXM, BMovYP, BMovYM, BMovZP, BMovZM;


/********************************************************************************
 *  Lokal globale Variablen
 ********************************************************************************/
static TKamera Kamera;


/*******************************************************************************
 *  void KameraZoom( Widget w, XtPointer Richtung, XtPointer garbage )
 *
 *  Beschreibung:
 *  -------------
 *  Set the zoom-factor. You have to notice that the zoom should not be lower 
 *  than 0.15! 
 ********************************************************************************/

void KameraZoom( Widget w, XtPointer Richtung, XtPointer garbage )
{
   if( (TBoolean) Richtung )
      AnimKamera.Zoom *= 1.1;
   else if( AnimKamera.Zoom > 0.15 )
      AnimKamera.Zoom /= 1.1;
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  void KameraPosPlus( Widget w, XtPointer Richtung, XtPointer garbage )
 *  XtPointer Richtung: Richtungsangabe: XRich | YRich | ZRich
 *
 *  Beschreibung:								
 *  -------------								
 *  Die Prozedur ruft zun"achst eine Routine zur Berechnung der Schrittweite auf.
 *  In Abh"angigkeit vom Parameter 'Richtung' wird die entsprechende Koordinate
 *  um die Schrittweite vergr"ossert. Anschliessend wird die Landschaft neu dar-
 *  stellt, da sich die Sicht darauf etwas ge"andert hat.
 ********************************************************************************/

void KameraPosPlus( Widget w, XtPointer Richtung, XtPointer garbage )
{
   TReal Schrittweite;

   /* Berechne Schrittweite aus Zoom, ... */
   if( AnimKamera.MountObj == NULL )
   {
      Schrittweite = 0.2/AnimKamera.Zoom;
      switch( (TRichtung) Richtung )
      {
	 case XRich: AnimKamera.Position[0] += Schrittweite;
                     break;
	 case YRich: AnimKamera.Position[1] += Schrittweite;
                     break;
	 case ZRich: AnimKamera.Position[2] -= Schrittweite;
                     break;
      }
   }
   else
   {
      Schrittweite = 0.05/AnimKamera.Zoom;
      switch( (TRichtung) Richtung )
      {
	 case XRich: AnimKamera.Offset[0] += Schrittweite;
	             AnimKamera.Position[0] += Schrittweite;
                     break;
	 case YRich: AnimKamera.Offset[1] += Schrittweite;
	             AnimKamera.Position[1] += Schrittweite;
                     break;
	 case ZRich: AnimKamera.Offset[2] -= Schrittweite;
	             AnimKamera.Position[2] -= Schrittweite;
                     break;
      }
   }
   /* Update des AnimationsFensters */
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  void KameraPosMinus( Widget w, XtPointer Richtung, XtPointer garbage )
 *  XtPointer Richtung: Richtungsangabe: XRich | YRich | ZRich									
 *  Beschreibung:								
 *  -------------								
 *  Die Prozedur ruft zun"achst eine Routine zur Berechnung der Schrittweite auf.
 *  In Abh"angigkeit vom Parameter 'Richtung' wird die entsprechende Koordinate
 *  um die Schrittweite verkleinert. Anschliessend wird die Landschaft neu dar-
 *  stellt, da sich die Sicht darauf etwas gendert hat.
 ********************************************************************************/

void KameraPosMinus( Widget w, XtPointer Richtung, XtPointer garbage )
{
   TReal Schrittweite;

   if( AnimKamera.MountObj == NULL )
   {
      Schrittweite = 0.2/AnimKamera.Zoom;
      switch( (TRichtung) Richtung )
      {
	 case XRich: AnimKamera.Position[0] -= Schrittweite;
	             break;
	 case YRich: AnimKamera.Position[1] -= Schrittweite;
                     break;
	 case ZRich: AnimKamera.Position[2] += Schrittweite;
                     break;
      }
   }
   else
   {
      Schrittweite = 0.05/AnimKamera.Zoom;
      switch( (TRichtung) Richtung )
      {
	 case XRich: AnimKamera.Offset[0] -= Schrittweite;
	             AnimKamera.Position[0] -= Schrittweite;
	             break;
	 case YRich: AnimKamera.Offset[1] -= Schrittweite;
	             AnimKamera.Position[1] -= Schrittweite;
                     break;
	 case ZRich: AnimKamera.Offset[2] += Schrittweite;
	             AnimKamera.Position[2] += Schrittweite;
                     break;
      }
   }   /* Jetzt sollte noch ein Refresh des Bildschirms erfolgen. */
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void KameraRotPlus( Widget w, XtPointer Richtung, XtPointer garbage )
{
   switch( (TRichtung) Richtung )
   {
      case XRich: Q_MUL( AnimKamera.Richtung, CRotXP, AnimKamera.Richtung );
                  break;
      case YRich: Q_MUL( AnimKamera.Richtung, CRotYP, AnimKamera.Richtung );
                  break;
      case ZRich: Q_MUL( AnimKamera.Richtung, CRotZP, AnimKamera.Richtung );
                  break;
   }
   /* jetzt noch ein Refresh des Bildschirms */
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void KameraRotMinus( Widget w, XtPointer Richtung, XtPointer garbage )
{
   switch( (TRichtung) Richtung )
   {
      case XRich: Q_MUL( AnimKamera.Richtung, CRotXM, AnimKamera.Richtung );
                  break;
      case YRich: Q_MUL( AnimKamera.Richtung, CRotYM, AnimKamera.Richtung );
                  break;
      case ZRich: Q_MUL( AnimKamera.Richtung, CRotZM, AnimKamera.Richtung );
                  break;
   }
   /* jetzt noch ein Refresh des Bildschirms */
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void KameraUndoRotations( Widget w, XtPointer muell, XtPointer garbage )
{
   AnimKamera.Richtung[0] = Kamera.Richtung[0];
   AnimKamera.Richtung[1] = Kamera.Richtung[1];
   AnimKamera.Richtung[2] = Kamera.Richtung[2];
   AnimKamera.Richtung[3] = Kamera.Richtung[3];
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


void KameraUndoTranslations( Widget w, XtPointer muell, XtPointer garbage )
{
   AnimKamera.Position[0] = Kamera.Position[0];
   AnimKamera.Position[1] = Kamera.Position[1];
   AnimKamera.Position[2] = Kamera.Position[2];
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


void KameraDefaults( Widget w, XtPointer Anzeige, XtPointer muell )
{
/*  Richtung = {0.98296290395980601, 0.12940952045410214, -0.12940952045410217, -0.017037086462466818}, */

   if( AnimKamera.MountObj == NULL )
   {
      AnimKamera.Position[0] =  1.4;
      AnimKamera.Position[1] =  1.4;
      AnimKamera.Position[2] = 5.0;
      AnimKamera.Richtung[0] = 0.98296290395980601;
      AnimKamera.Richtung[1] = 0.12940952045410214;
      AnimKamera.Richtung[2] = -0.12940952045410217;
      AnimKamera.Richtung[3] = -0.017037086462466818;
      AnimKamera.MountObj = NULL;
   }
   else
   {
      AnimKamera.Offset[0] =  0.0;
      AnimKamera.Offset[1] =  0.0;
      AnimKamera.Offset[2] =  0.0;
      AnimKamera.Position[0] = AnimKamera.MountObj->Position[0];
      AnimKamera.Position[1] = AnimKamera.MountObj->Position[1];
      AnimKamera.Position[2] = AnimKamera.MountObj->Position[2];
      AnimKamera.Richtung[0] = 1.0;
      AnimKamera.Richtung[1] = 0.0;
      AnimKamera.Richtung[2] = 0.0;
      AnimKamera.Richtung[3] = 0.0;
   }
   AnimKamera.Zoom = 1.0;
   if( (TBoolean) Anzeige )
      AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		        KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  void entbindeKamera( Widget w, XtPointer muell, XtPointer garbage )
 *
 *  Beschreibung:
 *  -------------
 *  Unmount camera from object.
 ********************************************************************************/

void entbindeKamera( Widget w, XtPointer muell, XtPointer garbage )
{
     AnimKamera.MountObj = NULL;
     AnimKamera.MountObjId = 0;
     AnimKamera.Offset[0] = 0.0;
     AnimKamera.Offset[1] = 0.0;
     AnimKamera.Offset[2] = 0.0;
}


/*******************************************************************************
 *  void KameraApply( Widget w, XtPointer muell, XtPointer garbage )
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine schlie"st das Fenster. Die eingestellten Kameradaten werden 
 *  "ubernommen.
 ********************************************************************************/

void KameraApply( Widget w, XtPointer muell, XtPointer garbage )
{
   XtPopdown( KW_Shell );
   AnimKameraOpen = FALSE;
}


/*******************************************************************************
 *  void KameraAbort( Widget w, XtPointer muell, XtPointer garbage )
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine schlie"st das Fenster. Die eingestellten Kameradaten werden 
 *  nicht "ubernommen. Da die verstellten Werte jedoch noch eine Auswirkung
 *  auf die Darstellung haben, sollte eine Redraw druchgef"uhrt werden, um die
 *  alten Einstellungen sichtbar zu machen.
 ********************************************************************************/

void KameraAbort( Widget w, XtPointer muell, XtPointer garbage )
{
   XtPopdown( KW_Shell );
   AnimKameraOpen = FALSE;
   AnimKamera = Kamera;
   AnzeigeAnimation( AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		     KoordAnAus|KoerperKoordAnAus|KraefteAnAus|dreiD );
}


/*******************************************************************************
 *  void KameraInit( Widget w, XtPointer garbage, XtPointer muell )
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine "offnet das Fenster. Die (globalen) Kameradaten werden in einer
 *  lokalen Kopie abgelegt.
 ********************************************************************************/

void KameraInit( Widget w, XtPointer garbage, XtPointer muell )
{
   if( !AnimKameraOpen )
   {
      Kamera = AnimKamera;
      AnimKameraOpen = TRUE;
   }
   XtPopup( KW_Shell, XtGrabNonexclusive );
}


/*******************************************************************************
 *  void installKamera( void )
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine installiert alle f"ur die Ab"anderung der Kameradaten ntigen 
 *  Buttons.
 ********************************************************************************/

void installKamera( void )
{
     Widget KW_box, KW_rotXP, KW_rotXM, KW_rotYP, KW_rotYM, KW_rotZP, KW_rotZM,
            KW_movXP, KW_movXM, KW_movYP, KW_movYM, KW_movZP, KW_movZM, KW_zoomP,
            KW_zoomM, KW_Apply, KW_Abort, KW_undoRot, KW_undoMov, KW_boxRot, 
            KW_boxMov, KW_default, KW_unbindKamera;

     KW_Shell = XtVaCreatePopupShell("Camera", topLevelShellWidgetClass, topLevel, NULL );
     KW_box = XtVaCreateManagedWidget("KW_box", formWidgetClass, KW_Shell, NULL );
     KW_boxRot = XtVaCreateManagedWidget("KW_boxRot", formWidgetClass, KW_box, NULL );
     KW_boxMov = XtVaCreateManagedWidget("KW_boxMov", formWidgetClass, KW_box, NULL );
     KW_rotXP = XtVaCreateManagedWidget("KW_rotXP", repeaterWidgetClass, KW_boxRot, 
					XtNbitmap, BRotXP, NULL );
     KW_rotXM = XtVaCreateManagedWidget("KW_rotXM", repeaterWidgetClass, KW_boxRot, 
					XtNbitmap, BRotXM, NULL );
     KW_movXP = XtVaCreateManagedWidget("KW_movXP", repeaterWidgetClass, KW_boxMov, 
					XtNbitmap, BMovXP, NULL );
     KW_movXM = XtVaCreateManagedWidget("KW_movXM", repeaterWidgetClass, KW_boxMov, 
					XtNbitmap, BMovXM, NULL );
     KW_rotYP = XtVaCreateManagedWidget("KW_rotYP", repeaterWidgetClass, KW_boxRot, 
					XtNbitmap, BRotYP, NULL );
     KW_rotYM = XtVaCreateManagedWidget("KW_rotYM", repeaterWidgetClass, KW_boxRot, 
					XtNbitmap, BRotYM, NULL );
     KW_movYP = XtVaCreateManagedWidget("KW_movYP", repeaterWidgetClass, KW_boxMov, 
					XtNbitmap, BMovYP, NULL );
     KW_movYM = XtVaCreateManagedWidget("KW_movYM", repeaterWidgetClass, KW_boxMov, 
					XtNbitmap, BMovYM, NULL );
     KW_rotZP = XtVaCreateManagedWidget("KW_rotZP", repeaterWidgetClass, KW_boxRot, 
					XtNbitmap, BRotZP, NULL );
     KW_rotZM = XtVaCreateManagedWidget("KW_rotZM", repeaterWidgetClass, KW_boxRot, 
					XtNbitmap, BRotZM, NULL );
     KW_movZP = XtVaCreateManagedWidget("KW_movZP", repeaterWidgetClass, KW_boxMov, 
					XtNbitmap, BMovZP, NULL );
     KW_movZM = XtVaCreateManagedWidget("KW_movZM", repeaterWidgetClass, KW_boxMov, 
					XtNbitmap, BMovZM, NULL );
     KW_undoRot = XtVaCreateManagedWidget("KW_undoRot", commandWidgetClass, KW_boxRot, NULL );
     KW_undoMov = XtVaCreateManagedWidget("KW_undoMov", commandWidgetClass, KW_boxMov, NULL );
     KW_default = XtVaCreateManagedWidget("KW_default", commandWidgetClass, KW_box, NULL );
     KW_unbindKamera = XtVaCreateManagedWidget("KW_unbindKamera", commandWidgetClass, KW_box, NULL );
     KW_zoomP = XtVaCreateManagedWidget("KW_zoomP", repeaterWidgetClass, KW_box, NULL );
     KW_zoomM = XtVaCreateManagedWidget("KW_zoomM", repeaterWidgetClass, KW_box, NULL );
     KW_Apply = XtVaCreateManagedWidget("KW_Apply", commandWidgetClass, KW_box, NULL );
     KW_Abort = XtVaCreateManagedWidget("KW_Abort", commandWidgetClass, KW_box, NULL );
     
     XtAddCallback( KW_Apply, XtNcallback, KameraApply, NULL );
     XtAddCallback( KW_Abort, XtNcallback, KameraAbort, NULL );
     XtAddCallback( KW_rotXP, XtNcallback, KameraRotPlus,  (XtPointer) XRich );   
     XtAddCallback( KW_rotXM, XtNcallback, KameraRotMinus, (XtPointer) XRich );   
     XtAddCallback( KW_rotYP, XtNcallback, KameraRotPlus,  (XtPointer) YRich );   
     XtAddCallback( KW_rotYM, XtNcallback, KameraRotMinus, (XtPointer) YRich );   
     XtAddCallback( KW_rotZP, XtNcallback, KameraRotPlus,  (XtPointer) ZRich );   
     XtAddCallback( KW_rotZM, XtNcallback, KameraRotMinus, (XtPointer) ZRich );  
     XtAddCallback( KW_movXP, XtNcallback, KameraPosPlus,  (XtPointer) XRich );   
     XtAddCallback( KW_movXM, XtNcallback, KameraPosMinus, (XtPointer) XRich );   
     XtAddCallback( KW_movYP, XtNcallback, KameraPosPlus,  (XtPointer) YRich ); 
     XtAddCallback( KW_movYM, XtNcallback, KameraPosMinus, (XtPointer) YRich );   
     XtAddCallback( KW_movZP, XtNcallback, KameraPosPlus,  (XtPointer) ZRich );   
     XtAddCallback( KW_movZM, XtNcallback, KameraPosMinus, (XtPointer) ZRich );   
     XtAddCallback( KW_default, XtNcallback, KameraDefaults, (XtPointer) TRUE );
     XtAddCallback( KW_unbindKamera, XtNcallback, entbindeKamera, NULL );
     XtAddCallback( KW_unbindKamera, XtNcallback, KameraDefaults, (XtPointer) TRUE );
     XtAddCallback( KW_zoomP, XtNcallback, KameraZoom, (XtPointer) TRUE );
     XtAddCallback( KW_zoomM, XtNcallback, KameraZoom, (XtPointer) FALSE );
     XtAddCallback( KW_undoRot, XtNcallback, KameraUndoRotations, NULL );
     XtAddCallback( KW_undoMov, XtNcallback, KameraUndoTranslations, NULL );
}

