/* example1.c
 */
#include <stdio.h>

#include "folgeschrittberechnung.h"
#include "materialien.h"

TKoerper k2 = {                     /* iron sphere */
    NULL,                           /* next body */
    KUGEL, { 0.01 }, EISEN, 0.0,    /* sphere, 0.01m-radius, iron */
    {0,1.0,0.0},{0,0,0},{0,0,0},    /* position, velocity, acc. */
    {1,0,0,0},{0,0,0},{0,0,0}       /* angular position(quaternion), vel., acc. */
};

TKraft f1 = {         /* horizontal force on k2 in the x-direction */
    NULL,             /* next force */
    0.1, 0.3,         /* active between time 0.1s and 0.3s */
    {0.0,0.0,0.0},    /* body-point of force */
    RAUMFEST,         /* force in world coordinates */
    {1.0, 0, 0}        /* 1 Newton force in x-direction */
};

TKoerper k1 = {                     /* plastic plane */
    &k2, EBENE, {0}, PLASTIK, 0.0,
    {0,0,0},{0,0,0},{0,0,0},        /* on position 0 */
    {1,0,0,0},{0,0,0},{0,0,0}
};

TZustand myworld = {
    0.0,                          /* start time 0.0sec */
    &k1, NULL,                    /* bodies, connections */
    &GrundMaterialien,            /* material table (out of materialien.c) */
    TRUE, {0.0, -9.81, 0.0}       /* gravity ON */
};


void step_output()
{
    printf("Time %fsec, sphere at x=%f, y=%f\n", 
	   myworld.Zeit, k2.Position[0], k2.Position[1]);
}

void main(int argc, char *argv[])
{
    TKonfigFBB konfig;

    /* initializing the Bodies 
     * for an more adequate initialation use the functions in koerper.h(body)
     * and materialien.h(materials)
     */
    KoeIniMech(&k1, myworld.MaterialDaten);  /* compute mass */
    KoeIniMech(&k2, myworld.MaterialDaten);   /* and set the motion-type */
    /* change the motion-type of the object after the KoeIniMech() !
     */
    k2.Kraefte = &f1;

    ErfrageKonfigFBB(&konfig);
    konfig.I_Fehlersteuerung = TRUE;  /* integration with step control */
    konfig.B_PenalityMethode = FALSE; /* don't use penality method for
				       * impacts */

    InitFBB(&myworld);

    KonfigFBB(&konfig);

    while (myworld.Zeit+0.05 <= 2.0) {
	step_output();
	FolgeBildBerechnung(&myworld, 0.05);
	UngeaendertFBB(&myworld);     /* don't use if you changed the world! */
    }
    step_output();

    EndFBB(&myworld);
}

