/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: koerper.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: koerper.o
 *  letzte Aenderung	: 03.04.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *  
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  24.01.93	KoeIniMech zum Modul Koerper dazugenommen. BewTyp benutzt
 *  27.01.93    Koerper EBENE, BewTyp GEFUEHRT setzen
 *  03.02.93    Die Temporaeren Var. ty, y a und u werden gesetzt.
 *              spricht Zugriff nur ueber ty(Read), y(Write) und a,u
 *  20.03.93    Angriffsflaeche zwecks Luftwiderstand berechnen (KoeIniMech)
 *  22.03.93    Routinen zwecks Masselos(unbeweglich) und Gravitationslos 
 *  24.03.93    Routine um Masse eines Koerpers extra zu setzten
 *  31.03.93    Kugelhuellenradius und halbe Kantenlaenge eingefuehrt
 *  01.04.93    Unterstuetzung des zusammengesetzten Koerpers
 *  03.04.93    Routinen um Koerper-Strukt. zu allokieren bzw. zu kopieren
 *  
 ********************************************************************************/

#include <math.h>
#include "koerper.h"
#include "vektor.h"



#define KL(x)  (k->Form.Quader.KantenLaenge[x])
#define QA KL(0)
#define QB KL(1)
#define QC KL(2)




void SetzeKoerperMasse(TKoerper *k, TReal masse) 
/****************************************************************************
 * Setzt Masse eines Koerpers auf Werte "masse". (Berechnet entsprechende
 * Traegheitstensore!)
 * Ist masse==0.0 wird der Koerper auf Masselos gesetzt
 */
{
    TReal r;
    int i, j;


    FehlerOrt("Koerperinitialisierung - Mechanik");


    if (k==NULL ) Fehler("Koerper == NULL");

    if (masse!=0.0) switch(k->Art) {
      case KUGEL:
	k->Kugelhuellenradius = k->Form.Kugel.Radius;

	k->Masse = masse;
	r = (k->Form.Kugel.Radius) * (k->Form.Kugel.Radius);
	r *= 0.4 * masse;	    /* Traegheitstensor */
	
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) 
	    k->Traegheitstensor[i][j] = (i == j) ? r : 0.0;
	
	r = 1.0 / r;
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) 
	    k->Traegheitstensor1[i][j] = (i == j) ? r : 0.0;
	break;
	
      case QUADER:
	V_SKALAR(k->HalbeKantenlaenge, k->Form.Quader.KantenLaenge, 0.5);
	k->Kugelhuellenradius = sqrt(QUADRAT(k->HalbeKantenlaenge[0]) +
				     QUADRAT(k->HalbeKantenlaenge[1]) +
				     QUADRAT(k->HalbeKantenlaenge[2]));
	
	k->Masse = masse;

	for (i=0; i<3; i++) {
	    r = (QUADRAT(k->Form.Quader.KantenLaenge[(i+1)%3]) +
		 QUADRAT(k->Form.Quader.KantenLaenge[(i+2)%3])) * masse / 12.0;
	    for (j=0; j<3; j++) {
		if (i==j) {
		    k->Traegheitstensor[i][j] = r;
		    k->Traegheitstensor1[i][j] = 1.0 / r;
		}
		else {
		    k->Traegheitstensor[i][j] = 0.0;
		    k->Traegheitstensor1[i][j] = 0.0;
		}
	    }
	}
	break;

      case ZYLINDER:
	k->HalbeKantenlaenge[0] = k->Form.Zylinder.Radius;
	k->HalbeKantenlaenge[1] = k->Form.Zylinder.Radius;
	k->HalbeKantenlaenge[2] = k->Form.Zylinder.Hoehe * 0.5;
	k->Kugelhuellenradius = sqrt(QUADRAT(k->HalbeKantenlaenge[0]) +
				     QUADRAT(k->HalbeKantenlaenge[1]) +
				     QUADRAT(k->HalbeKantenlaenge[2]));
	
	k->Masse = masse;
	for (i=0; i<3; i++)
	    for (j=0; j<3; j++) {
		k->Traegheitstensor[i][j] = 0.0;
		k->Traegheitstensor1[i][j] = 0.0;
	    }
	r = (QUADRAT(k->Form.Zylinder.Radius)+ QUADRAT(k->Form.Zylinder.Hoehe)/3.0)
	    * masse / 4.0;
	k->Traegheitstensor[0][0] = r;
	k->Traegheitstensor1[0][0] = 1.0 / r;
	k->Traegheitstensor[1][1] = r;
	k->Traegheitstensor1[1][1] = 1.0 / r;
	r = QUADRAT(k->Form.Zylinder.Radius) * masse / 2.0;
	k->Traegheitstensor[2][2] = r;
	k->Traegheitstensor1[2][2] = 1.0 / r;
	break;


      case MPUNKT:            /* Massepunkt hat keine Ausdehnung */
      case ZUSGESOBJ:         /* Bei Benutzer-Angabe wird aus ZusGesObj ein Massepunkt */
	k->Masse = masse;
	r = 1 / masse;
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) {
            k->Traegheitstensor[i][j] = (i == j) ? masse : 0.0;
	    k->Traegheitstensor1[i][j] = (i == j) ? r : 0.0;;
	  }
	break;

      default:
	break;
    }
    else {
	SetzeKoerperMasselos(k, TRUE);
    }
}


void EingKoeIniMech(TKoerper *k, TMaterialTabelle *MatTab)
/****************************************************************************
 * Initialisierung einer eingebetteten Koerper-Struktur.
 * berechnet werden die Position, Masse und Orientierung des Root-Koerpers
 * sowie die relativ-Positionen der eingebetteten Koerper.
 */
{
    TKoerper *ek;
    TVektor rs, v;
    TReal masse, flaeche, huelle, f;
    TMatrix A;
    TQuaternion q;
    int i, j;
    
 
    FehlerOrt("Eingebettete Koerperinitialisierung - Mechanik");


    masse = 0.0;
    flaeche = 0.0;
    V_SET(rs, 0.0, 0.0, 0.0);
    
    /* Masse, Angriffsflaeche und Schwerpunkt des ZusGesKoerper bestimmen
     * OberKoerper der eingebetteten Koerper auf ZusGesObj setzten 
     */
    for (ek=k->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {
	masse += ek->Masse;
	flaeche += ek->Angriffsflaeche;
	V_ADDSKAL(rs, rs, ek->Masse, ek->Position);
	ek->OberKoerper = k;
    }
    k->Angriffsflaeche = flaeche;
    k->Masse = masse;

    /* Schwerpunkt und Traegheitstensor ausrechnen */
    if (masse != 0.0) {
	f = 1.0/masse;
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) {
            k->Traegheitstensor[i][j] = (i == j) ? masse : 0.0;
	    k->Traegheitstensor1[i][j] = (i == j) ? f : 0.0;;
	  }

	V_SKALAR(rs, rs, f);
    }

    V_LET(k->Position, rs);
    k->q[0] = 1.0;
    k->q[1] = 0.0;
    k->q[2] = 0.0;
    k->q[3] = 0.0;

    /* Umgebenden Kugelhuellenradius bestimmen,
     * relative Position der eingebetteten Koerper zum ZusGesObj-Schwerpunkt
     * sowie die Drehung des Eing.Koerperkoord. zum ZusGesObjkoord.
     * Die obigen Werte sind alle Konstant!
     */    
    huelle = 0.0;
    for (ek=k->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {
	V_SUB(ek->Position_bzg_ZGO, ek->Position, rs);
	ek->q_bzg_ZGO[0] = ek->q[0];
	ek->q_bzg_ZGO[1] = ek->q[1];
	ek->q_bzg_ZGO[2] = ek->q[2];
	ek->q_bzg_ZGO[3] = ek->q[3];
/*
	q[0] = k->q[0];	/* Drehung zw. ZusGesObj-KoerperKoord. *
	q[1] = - k->q[1];         /* und eingebettetem Obj. *
	q[2] = - k->q[2];
	q[3] = - k->q[3];
        Q_MULT(ek->q_bzg_ZGO, ek->q, q);              
        q[0] = ek->q_bzg_ZGO[0];
        q[1] = -ek->q_bzg_ZGO[1];
        q[2] = -ek->q_bzg_ZGO[2];
        q[3] = -ek->q_bzg_ZGO[3];
	RotMatrix(A, q);

	V_SUB(v, ek->Position, rs);             /* in raumkoord *
	MV_MUL2(ek->Position_bzg_ZGO, A, v); 
	
*/
	f = ek->Kugelhuellenradius + V_BETRAG(ek->Position_bzg_ZGO);
	if (f>huelle) huelle = f;
    }
    k->Kugelhuellenradius = huelle;

    if (masse == 0.0) SetzeKoerperMasselos(k, TRUE);
}


void KoeIniMech(TKoerper *k, TMaterialTabelle *MatTab)
/****************************************************************************
 * Initialisierungsroutine der Mechanischen Werte fuer einen Koerper.
 */
{
    TReal r, V, dichte;
    int i, j;


    FehlerOrt("Koerperinitialisierung - Mechanik");


    if (MatTab == NULL || k==NULL) Fehler("Koerper oder Materialtabelle == NULL");


    k->ty = (struct TIVariablen *) &(k->Position);   
    k->y = k->ty;
    V_LET(k->a, k->Beschleunigung);
    V_LET(k->u, k->Drehbeschleunigung);

    k->Angriffsflaeche = 0.0;    
    k->OberKoerper = k;

    switch(k->Art) {
      case KUGEL:
	k->BewTyp = FREI | KOLL;

	k->Kugelhuellenradius = k->Form.Kugel.Radius;

        /* Volumen ausrechnen */
	dichte = Dichte(MatTab, k->Material);
	V = 4.0 / 3.0 * PI * pow(k->Form.Kugel.Radius,3.0);
	k->Masse = dichte * V;
	  
	if (k->Masse == 0.0) break;
	/* aus Technische Formeln S.145ff */
	r = (k->Form.Kugel.Radius) * (k->Form.Kugel.Radius);
	k->Angriffsflaeche = r * PI; /* Luftwiderstandsangriffsflaeche */

	r *= 0.4 * (k->Masse);	/* Traegheitstensor */
	
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) 
	    k->Traegheitstensor[i][j] = (i == j) ? r : 0.0;
	
	r = 1.0 / r;
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) 
	    k->Traegheitstensor1[i][j] = (i == j) ? r : 0.0;
	break;
	
      case QUADER:
	k->BewTyp = FREI | KOLL;

	V_SKALAR(k->HalbeKantenlaenge, k->Form.Quader.KantenLaenge, 0.5);
	k->Kugelhuellenradius = V_BETRAG(k->HalbeKantenlaenge);

	dichte = Dichte(MatTab, k->Material);
	V = k->Form.Quader.KantenLaenge[0] *
	    k->Form.Quader.KantenLaenge[1] *
	    k->Form.Quader.KantenLaenge[2];
	k->Masse = dichte * V;

	for (i=0; i<3; i++) {
	    r = (QUADRAT(k->Form.Quader.KantenLaenge[(i+1)%3]) +
		 QUADRAT(k->Form.Quader.KantenLaenge[(i+2)%3])) * k->Masse / 12.0;
	    for (j=0; j<3; j++) {
		if (i==j) {
		    k->Traegheitstensor[i][j] = r;
		    k->Traegheitstensor1[i][j] = 1.0 / r;
		}
		else {
		    k->Traegheitstensor[i][j] = 0.0;
		    k->Traegheitstensor1[i][j] = 0.0;
		}
	    }
	}
	k->Angriffsflaeche = (QA*(QA+QC)+QA*QC)/3.0;
	break;

      case ZYLINDER:
	k->BewTyp = FREI | KOLL;

	k->HalbeKantenlaenge[0] = k->Form.Zylinder.Radius;
	k->HalbeKantenlaenge[1] = k->Form.Zylinder.Radius;
	k->HalbeKantenlaenge[2] = k->Form.Zylinder.Hoehe * 0.5;
	k->Kugelhuellenradius = V_BETRAG(k->HalbeKantenlaenge);

	dichte = Dichte(MatTab, k->Material);
	V = PI * k->Form.Zylinder.Radius * k->Form.Zylinder.Radius 
	  * k->Form.Zylinder.Hoehe;
	k->Masse = dichte * V;
	for (i=0; i<3; i++)
	    for (j=0; j<3; j++) {
		k->Traegheitstensor[i][j] = 0.0;
		k->Traegheitstensor1[i][j] = 0.0;
	    }
	r = (QUADRAT(k->Form.Zylinder.Radius)+ QUADRAT(k->Form.Zylinder.Hoehe)/3.0)
	    * k->Masse / 4.0;
	k->Traegheitstensor[0][0] = r;
	k->Traegheitstensor1[0][0] = 1.0 / r;
	k->Traegheitstensor[1][1] = r;
	k->Traegheitstensor1[1][1] = 1.0 / r;
	r = QUADRAT(k->Form.Zylinder.Radius) * k->Masse / 2.0;
	k->Traegheitstensor[2][2] = r;
	k->Traegheitstensor1[2][2] = 1.0 / r;

	k->Angriffsflaeche = 0.5 * PI * QUADRAT(k->Form.Zylinder.Radius) +
			    k->Form.Zylinder.Radius * k->Form.Zylinder.Hoehe;
	break;


      case MPUNKT:            /* Massepunkt hat keine Ausdehnung */
	k->BewTyp = FREI;
	r = 1 / k->Masse;
	for (i=0; i<3; i++)
	  for (j=0; j<3; j++) {
            k->Traegheitstensor[i][j] = (i == j) ? k->Masse : 0.0;
	    k->Traegheitstensor1[i][j] = (i == j) ? r : 0.0;;
	  }
	k->Angriffsflaeche = 0.0;
	break;

      case NAGEL:
      case PUNKT:
	k->Masse = 0.0;
	k->BewTyp = MASSELOS;
	V_SET(k->Geschwindigkeit, 0.0, 0.0, 0.0);
	V_SET(k->Beschleunigung, 0.0, 0.0, 0.0);
	V_SET(k->Drehgeschwindigkeit, 0.0, 0.0, 0.0);
	V_SET(k->Drehbeschleunigung, 0.0, 0.0, 0.0);
	break;
	
      case EBENE:
	k->Masse = 0.0;
	k->BewTyp = GEFUEHRT|MASSELOS|KOLL;
	V_SET(k->Geschwindigkeit, 0.0, 0.0, 0.0);
	V_SET(k->Beschleunigung, 0.0, 0.0, 0.0);
	V_SET(k->Drehgeschwindigkeit, 0.0, 0.0, 0.0);
	V_SET(k->Drehbeschleunigung, 0.0, 0.0, 0.0);
	break;


      case ZUSGESOBJ:
	if (k->Form.ZusGesObj.KoerperListe) {
	    EingKoeIniMech(k, MatTab);
	    k->BewTyp = FREI|KOLL;
	}
	else {
	    k->Masse = 1.0;
	    k->BewTyp = FREI|KOLL;
	    k->Angriffsflaeche = 0.0;
	    k->Kugelhuellenradius = 0.0;
	}
	break;
	      
	
      default:
	Fehler("Unterstuetze Koerperart nicht");
	break;
    }
}


void SetzeKoerperMasselos(TKoerper *k, TBoolean masselos)
{
    if (k==NULL) Fehler("Koerperzeiger k=NULL");
    
    switch(k->Art) {
      case KUGEL:
      case QUADER:
      case ZYLINDER:
      case ZUSGESOBJ:
	if (masselos)
	  k->BewTyp = ((k->BewTyp) & (~FREI)) | MASSELOS;
	else 
	  k->BewTyp = ((k->BewTyp) & (~MASSELOS)) | FREI;
	V_SET(k->Geschwindigkeit, 0.0, 0.0, 0.0);
	V_SET(k->Beschleunigung, 0.0, 0.0, 0.0);
	V_SET(k->Drehgeschwindigkeit, 0.0, 0.0, 0.0);
	V_SET(k->Drehbeschleunigung, 0.0, 0.0, 0.0);
	break;

      default:
	break;
    }
}


TBoolean IstKoerperMasselos(TKoerper *k)
{
    return ((k->BewTyp) & MASSELOS) ? TRUE : FALSE;
}




void SetzeKoerperGravlos(TKoerper *k, TBoolean nograv)
{
    if (k==NULL) Fehler("Koerperzeiger k=NULL");

    switch(k->Art) {
      case KUGEL:
      case QUADER:
      case ZYLINDER:
      case ZUSGESOBJ:
	if (nograv)
	  k->BewTyp |= GRAV0;
	else 
	  k->BewTyp = ((k->BewTyp) & (~GRAV0));
	break;

      default:
	break;
    }
}

    
TBoolean IstKoerperGravlos(TKoerper *k)
{
    return ((k->BewTyp) & GRAV0) ? TRUE : FALSE;
}


void SetzeKoerperKollmoeglich(TKoerper *k, TBoolean koll)
{
    if (k==NULL) Fehler("Koerperzeiger k=NULL");

    switch(k->Art) {
      case KUGEL:
      case QUADER:
      case ZYLINDER:
      case ZUSGESOBJ:
      case EBENE:
	if (koll)
	  k->BewTyp |= KOLL;
	else 
	  k->BewTyp = ((k->BewTyp) & (~KOLL));
	break;

      default:
	break;
    }
}

    
TBoolean IstKoerperKollmoeglich(TKoerper *k)
{
    return ((k->BewTyp) & KOLL) ? TRUE : FALSE;
}




void KoerperKopieren(TKoerper *nach, TKoerper *von, TKoerper *neuerober)
/****************************************************************************
 * Zweck:
 *   Kopiert den Inhalt der Koerperstruktur von Koerper "von" zum Koerper
 *   "nach".  
 *   Kraefte-Strukturen oder eingebettete Koerper werden nicht mitkopiert!
 *   
 */
{
    if (nach && von) {
	*nach = *von;
	nach->OberKoerper = neuerober;
  }
}



TKoerper *KoerperAllozieren()
/****************************************************************************
 * Zweck:
 *   Belegt Speicher fuer eine Koerper-Struktur.
 *   Freigabe kann mit dem free-Aufruf gemacht werden!
 *   
 * Rueckgabewert:
 *   Zeiger auf die allozierte (aber uninitialisierte) Struktur 
 *   oder NULL wenn kein Speicher angefordert werden konnte.
 *   
 */
{
    return (TKoerper *)malloc(sizeof(TKoerper));
}



void ZusGesObjRot(TKoerper *k)
{
    TKoerper *ek;
    TVektor v;


    /* bei einem Zusammengesetzen Koerper auch die Rotmatrizen und Positionen der
     * eingebetteten Koerper berechen
     */
    if (k && (k->Art==ZUSGESOBJ)) {
	RotMatrizen(k->RotTrans1, k->RotTrans, k->ty->q);
	
	for (ek=k->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {
	    
	    MV_MUL2(v, k->RotTrans1, ek->Position_bzg_ZGO);
	    V_ADD(ek->Position, k->Position, v);
	    
	    Q_MUL(ek->q, ek->q_bzg_ZGO, k->q); 
	    RotMatrizen(ek->RotTrans1, ek->RotTrans, ek->q);
	}	
    }
}

