/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: konfig.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: konfig.o
 *  letzte Aenderung	: 25.02.93
 *  Autor		: Horst Stolz (HUS)
 *
 *  Bemerkung:
 *    Alle TReal-Eintraege muessen mit Werte belegt werden die mindesten >=0.0
 *    sind.
 *    Die Schrittsteuerung sollte derzeit nur vor dem ersten Aufruf der
 *    FBB(..) geaendert werden.
 *  
 *  Versionsgeschichte:
 *  25.02.93	Erstellungsdatum
 *  31.03.93    K_SimStoss durch K_FederStoss ersetzt
 *              K_MaxQuaderQuerTiefe eingefuehrt (-> fuer Quaderkollision)
 *  
 ********************************************************************************/
#ifndef KONFIG_H
#define KONFIG_H


#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif



typedef struct TKonfigFBB {
    /* Einstellparameter fuer das Integrationsverfahren
     *
     * I_Schritt:
     *    Schrittweite mit der das Integrationsverfahren startet
     *
     * I_Fehlersteuerung:
     *    FALSE - Feste Schrittweite, Eps, MinSchritt und MaxSchritt unwirksam!
     *    TRUE  - Schrittweite wird aufgrund der gewollten Genauigkeit 
     *            variiert (->Geschwindigkeitsgewinn & Interpolation im letzen
     *            Integrationsschritt moeglich)
     *
     * I_Eps:
     *    Genauigkeit zwischen den Einzelschritten. Reicht die Schrittweite
     *    nicht aus um die Genauigkeit zu erreichen so wird die Schrittweite 
     *    verkleinert. Falls mit der Schrittweite zu zu genauen Ergebnissen
     *    fuehrt wird die Schrittweite vergroessert.
     *
     * I_MinSchritt, I_MaxSchritt:
     *    Schrittweite wird zwischen diesen beiden Werten variiert!
     *    0.0 < I_MinSchritt <= I_Schritt <= I_MaxSchritt
     *
     * Die Parameter fuer das Integrationsverfahren duerfen nur zwischen zwei
     * FBB(..) gesetzt werden wenn man den Zustand als geandert betrachtet!
     * Also nicht UngeaendertFBB(..) aufrufen.
     * 
     */

    TReal         I_Schritt;			/* I_SCHRITTWEITE */
    TBoolean	  I_Fehlersteuerung;		/* I_STEUERUNG */
    TReal         I_Eps;			/* I_EPS */
    TReal	  I_MinSchritt;			/* I_MINSHRITT (bei Fehlerste.) */
    TReal         I_MaxSchritt;			/* I_MAXSHRITT ( " ) */


    /* Steuerung der Kollisionserkennung
     *
     * K_Kollisionserkennung:
     *    TRUE - Es wird auf Kollisionen (Beruehrung & Stoss) reagiert
     *    FALSE - Koerper koennen ungehindert durch andere Koerper gehen
     *
     * K_KollSchritt:
     *    Schrittweite an denen eine Stossbehandlung stattfindet.
     *    Die Erkennung einer Kollision geschieht in jedem Funktionsaufruf
     *    der Integrationsroutine. Beruehrungen koennen direkt aufgeloest
     *    werden, aber bei Stoessen muss die Integration stoppen und mit
     *    neuen Anfangswerten(sprich - Geschwindigkeiten)  starten.
     *    Liegt die Kollisionsschrittweite unter der Integrationsschrittweite
     *    so mach das Integrationsverfahren eben kleinere Schritte!
     */
    TBoolean	  K_Kollisionserkennung;	/* K_KOLERKENNUNG */
    TReal	  K_KollSchritt;		/* Kollisionsschrittweite */


    /* Parameter die die Beruehrungsbehandlung beeinflussen
     *
     * B_MaxBerGeschw:
     *   Gibt an ab welcher Maximalen Normalgeschwindigkeit im Beruehrpunkt die
     *   "Kollision" als Beruehrung gilt. Liegt sie oberhalb so handelt es sich
     *   um einen Stoss!
     *
     * B_PenalityMethode:
     *   TRUE - Es wird einfach aus der Beruehrungstiefe und der Normalgeschw.
     *          eine Beruehrkraft angesetzt. -> Koerper sinkt ein.
     *          => schwere Koerper sinken staerker ein als Leichte.
     *   FALSE - Es werden aus die "exakten" Beruehrungskraefte errechnet um
     *           eine Durchdringung zu verhindern.
     *           (Rechenintensiver)
     * B_MinBerTiefe:
     *   Schwellwert ab der die Beruehrungstiefe sich auf die exakte Beruehrkraft
     *   auswirkt. (wird nicht bei der Penality-Methode benutzt!)
     * 
     */
    TReal	  B_MaxBerGeschw;		/* B_MAXBERGESCHW */
    TBoolean	  B_PenalityMethode;		/* B_STEUERUNG */
    TReal         B_MinBerTiefe;


    /* Reibungsparameter
     *
     * R_MinGleitGeschw:  
     *   Wenn die Geschwindigkeitskomponente die Rechtwinkling zur Normalerichtung
     *   im Beruehrpunkt ueber diesem Schwellenwert liegt so wird eine sich 
     *   aus der Beruehrkraft ergebende Reibungskraft mit angelegt. 
     *
     * R_MinRollGeschw:
     *   Wird noch nicht unterstuetzt
     * 
     */
    TReal         R_MinGleitGeschw;		/* R_MINGLEITGESCHW */
    TReal         R_MinRollGeschw;


    /* Wenn G_Zufall auf TRUE gesetzt wird addiert sich ein Zufaelliger
     * Wert |x|<=ZufGravAnteil*|g|/100 zu den Gravitationsvektorkomponenten.
     */
    TBoolean      G_Zufall;			/* Zufall AN/AUS */
    TReal         G_ZufGravAnteil;   	        /* Angabe in % (Prozent) */


    /* Federkonstante c  und Daempfungskonstante d  fuer die
     * Verbindungen Gelenk und Stange.
     *
     */
    TReal         C_Gelenk_d;
    TReal         C_Gelenk_c;
    TReal         C_Stange_d;
    TReal         C_Stange_c;

    /* Minimale Positionsunterschied bei der Verbingung Feder ab dem die Feder
     * erst reagiert. (>=0.0!)
     *
     */
    TReal         F_MinDehnung;			/* MinFederdehnung */    


    /* Stoss-Aufloesung durch eine "Feder-Kraft" die proportional zur 
     * Durchdringungstiefe ist.
     */
    TBoolean      K_FederStoss;              

    /* Falls L_Luftwiderstand auf TRUE wird anhand den Beiwerten sowie der
     * Koerperflaeche eine Gegenkraft an den Koerperschwerpunkt angebracht 
     * die proportional zum Geschwindigkeitsquadrat ist.
     */
    TBoolean      L_Luftwiderstand;
    TReal         L_Beiwert_Kugel;
    TReal         L_Beiwert_Quader;
    TReal         L_Beiwert_Zylinder;

    /* Im Kollisionstest zwischen zwei Quader wird beim test Kante gegen Quader
     * Durchdringungstiefe ueber der diesem Wert nicht mehr zugelassen.
     * (Tiefe wird auf 0.0 gesetzt)
     */
    TReal         K_MaxQuaderQuerTiefe;

} TKonfigFBB;


extern TKonfigFBB Konfiguration;

#endif
