// -*- C++ -*-
//--------------------------------------------------------------------
// KRay Version 0.1
//
// File: raywidget.h
//
// Classes: dlgRay
//
// Purpose: This is the main dialog of the program.  
//--------------------------------------------------------------------
#ifndef __raywidget_h
#define __raywidget_h

#include <ktopwidget.h>
#include <qchkbox.h>
class Engine; // from engine.h
class Screen; // from screen.h

class dlgRay : public KTopLevelWidget
{
    Q_OBJECT
public:

    dlgRay
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );
    virtual ~dlgRay();

private slots:
    virtual void generate();
    virtual void quit();
protected slots:
    virtual void updateYsize(const char*);
signals:
    void squit();
    void sgenerate(int, int, int, int, int, int);

protected:
    void initMenu();
    void initDialogElements();
    void closeEvent( QCloseEvent* );

    QMenuBar* Menu;
    QPopupMenu *File, *Help;
    QLineEdit* xsize;
    QLineEdit* ysize;
    QComboBox* Sphere1Surface;
    QComboBox* Sphere2Surface;
    QComboBox* GroundSurface;
    QComboBox* HellSurface;
    QComboBox* SkySurface;
    QCheckBox* ratioCheckbox;
private:
    Engine* myEngine;
    Screen* myScreen;
};

#endif // dlgRay_included


