/* this, given a petal primitive, will make a flower */

#include <math.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#define NUM_SIDES (float)12
#define UNITS (float)360
#define ANGLE (float)33
#define SCENE 1
#define NAME_SIZE 30

float num_sides=NUM_SIDES, units=UNITS, angle=ANGLE;

int scene=SCENE;

char petal_name[NAME_SIZE],flower_name[NAME_SIZE];

main(argc,argv)
int argc;
char **argv;
{
float a;
 
int c;

/* Command-line options:
   s number of sides
   a angle of flower petals
   f name of flower object
   n name of petal object
   o output format [p2s and p2i only currently supported]
   t flower type [ds1 only currently supported]
*/

strcpy(flower_name,"flower");
strcpy(petal_name,"petal");

opterr = 0;
while( (c = getopt(argc, argv, "s:a:f:n:o:t:")) != -1)
   {
   switch (c)
     {

     case 's':
       {
       num_sides = atof(optarg);
       if(num_sides<1)
         num_sides=NUM_SIDES; 
       break;
       }

     case 'a':
       {
       angle = atof(optarg);
       break;
       }

     case 'f':
       {
       strncpy(flower_name,optarg,NAME_SIZE);
       break;
       }

     case 'n':
       {
       strncpy(petal_name,optarg,NAME_SIZE);
       break;
       }

     case 't':
       {
       if(strcmp("ds1",optarg))
         {
         fprintf(stderr,"Error: Flower type %s unsupported.\n",optarg);
         exit(2);
         }
       break;
       }

     case 'o':
       {
       scene = 0;
       if(strcmp("p2i",optarg))
         {
         scene++;
         if(strcmp("p2s",optarg))
           {
           fprintf(stderr,"Error: Output format %s unsupported.\n",optarg);
           exit(3);
           }
         }
       break;
       }

     case '?':
       {
       fprintf(stderr,"WARNING: Invalid option %c ignored. Valid options: sanot\n", c);
       break;
       }

     }
   }

printf("// This file was generated by the flower renderer by Sam Trenholme\n");
printf("\n\n");

if(scene)
  printf("#include \"petal.inc\"\n\n");

printf("#declare Flower_Texture= texture {\n");
printf("                pigment{color red 0.830 green 0.830 blue 0.000}}\n");
printf("\n");

printf("#declare %s = union {\n",flower_name);
printf("       object {object{sphere {<0,0,0>, 10.0\n");
printf("               texture{Flower_Texture}\n");
printf("               finish{ambient 0.1 reflection 0.9 phong 0.1}\n");
printf("       } scale<1,1,.25>} translate <0,0,%f>}\n",sin(angle * PI / 180)*10);
printf("\nobject{ union{\n\n");

for(a=0;a<units;a+=units/num_sides)
   {
   printf("object\n {object\n  {%s translate<0,%f,0>",petal_name,(float)-16);
   printf("\n   }  rotate<-%f,0,%f>}\n",angle,a);
   }

printf("\n} // union\n");
printf("   texture{Flower_Texture} finish{ambient 0.4 reflection 0.4 phong 0.8}\n");
printf("}\n}\n");

if(scene)
   {
   printf("camera {\n  location <0, 42, 42>\n  direction <1.0,0,0>\n");
   printf("  sky<0,-1,0>\n  look_at   <0, 0, 0>\n}\n\n");
   
   printf("light_source { <20, 40, -30> color red 1 green 1 blue 1}\n");
   printf("light_source { <-15, 30, 40> color red 1 green 1 blue 1}\n");

   printf("\nobject {%s}\n",flower_name);   
   }

}
