program exa_colour3d
    use dislin
    implicit none
 
    integer, parameter :: n=100
    real, dimension (n,n) :: zmat
    character (len=8) :: cdev
    real    :: fpi,step,x,y
    integer :: i,j
 
    fpi=3.1415927/180.0
    step=360.0/(n-1)
    do i=1,n
      x=(i-1)*step
      do j=1,n
        y=(j-1)*step
        zmat(i,j)=2*sin(x*fpi)*sin(y*fpi)
      end do
    end do

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)

    call disini()
    call pagera()
    call hwfont()
 
    call titlin("3-D Colour Plot of the Function",2)
    call titlin("F(X,Y) = 2 * SIN(X) * SIN(Y)",4)
 
    call name("X-axis","x")
    call name("Y-axis","y")
    call name("Z-axis","z")
 
    call intax()
    call autres(n,n)
    call axspos(300,1850)
    call ax3len(2200,1400,1400)
 
    call graf3(0.0,360.0,0.0,90.0,0.0,360.0,0.0,90.0,-2.0,2.0,-2.0,1.0)
    call crvmat(zmat,n,n,1,1)
 
    call height(50)
    call title()
    call mpaepl(3)
    call disfin()
end program exa_colour3d



