program exa_curve   
   use dislin
   implicit none

    integer, parameter :: n=100
    real, dimension (n) :: xray,y1ray,y2ray
    real, parameter :: pi=3.1415926
    real :: fpi,step,x
    integer :: i
    character (len=8) :: cdev
  
    fpi=pi/180.0
    step=360.0/(n-1)
 
    do i=1,n
      xray(i)=(i-1)*step
      x=xray(i)*fpi
      y1ray(i)=sin(x)
      y2ray(i)=cos(x)
    end do
 
    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)

    call disini()
    call pagera()
    call complx()
    call axspos(450,1800)
    call axslen(2200,1200)
 
    call name("X-axis","x")
    call name("Y-axis","y")
 
    call labdig(-1,"x")            ! replaces digits
    call ticks(10,"xy")
 
    call titlin("Demonstration of CURVE",1)
    call titlin("SIN(X), COS(X)",3)
 
    call graf(0.0,360.0,0.0,90.0,-1.0,1.0,-1.0,0.5)
    call title()
 
    call color("red")
    call curve(xray,y1ray,n)
    call color("green")
    call curve(xray,y2ray,n)
 
    call color("white")
    call dash()
    call xaxgit()
 
    call disfin()
end program exa_curve


