program exa_interp
    use dislin
    implicit none
 
    real, dimension (16), parameter :: &
        x = (/0.0,  1.0,  3.0,  4.5,  6.0,  8.0,  9.0, 11.0, &
             12.0, 12.5, 13.0, 15.0, 16.0, 17.0, 19.0, 20.0/),&
        y = (/2.0,  4.0,  4.5,  3.0,  1.0,  7.0,  2.0,  3.0, &
              5.0,  2.0,  2.5,  2.0,  4.0,  6.0,  5.5,  4.0/)
    character (len=8) :: cdev 
    character (len = *), parameter :: ctit = "Interpolation Methods"
    character (len = *), dimension (4), parameter :: &
              cpol = (/"SPLINE","BARS  ","STEP  ","LINEAR"/)
    integer :: i,nx,ny,nya

    nya=2700

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)

    call setpag("da4p")
    call disini()
    call complx()
    call pagera()
    call incmrk(1)
    call hsymbl(25)
    call titlin(ctit,1)
    call axslen(1500,500)
    call setgrf("line","line","line","line")
 
    do i=1,4
      call axspos(350,nya-(i-1)*500)
      call polcrv(cpol(i))
      call marker(0)
 
      call graf(0.0,20.0,0.0,5.0,0.0,10.0,0.0,5.0)
      nx=nxposn(1.0)
      ny=nyposn(8.0)
      call color("yellow")
      call messag(cpol(i),nx,ny)
      call curve(x,y,16)
      call color("white")
 
      if(i == 4) then
        call height(50)
        call title()
      end if
      call endgrf()
    end do
 
    call disfin()
end program exa_interp
