program exa_lambert
    use dislin
    implicit none

    character (len=8) :: cdev
    character (len=*), parameter :: ctit = "Azimuthal Lambert Projections"
    integer, dimension (4), parameter :: nxa = (/200,1150,200,1150/), &
                                nya = (/1600,1600,2700,2700/)
    real, dimension (4), parameter ::   xpol = (/0.0, 0.0, 0.0  ,0.0/), &
                                        ypol = (/0.0,45.0,90.0,-45.0/)
    integer :: i,nx,nl

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)

    call setpag("da4p")
    call disini()
    call complx()
    call pagera()
 
    call height(50)
    nl=nlmess(ctit)
    nx=(2250-nl)/2
    call messag(ctit,nx,300)
 
    call axslen(900,900)
    call projct("lambert")
 
    do i=1,4
      call axspos(nxa(i),nya(i))
      call mappol(xpol(i),ypol(i))
      call grafmp(-180.0,180.0,-180.0,30.0,-90.0,90.0,-90.0,30.0)
 
      call color("green")
      call world()
      call color("white")
      call gridmp(1,1)
      call endgrf()
    end do
 
    call disfin()
end program exa_lambert 
