program exa_legend
    use dislin
    implicit none
 
    integer, parameter :: n=100
    real, dimension (n) :: xray,y1ray,y2ray
    character (len=14) :: cbuf
    character (len=8)  :: cdev
    real :: fpi,step,x
    integer :: i,nx,ny
 
    fpi=3.1415926/180.0
    step=360.0/(n-1)
    do i=1,n
      xray(i)=(i-1)*step
      x=xray(i)*fpi
      y1ray(i)=sin(x)
      y2ray(i)=cos(x)
    end do

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)

    call disini()
    call complx()
    call pagera()
 
    call axspos(450,1800)
    call axslen(2200,1200)
 
    call name("x-axis","x")
    call name("y-axis","y")
    call labdig(-1,"x")         ! Replaces DIGITS
    call ticks(10,"xy")
 
    call titlin("Demonstration of CURVE",1)
    call titlin("Legend",3)
 
    call graf(0.0,360.0,0.0,90.0,-1.0,1.0,-1.0,0.5)
    call title()
    call xaxgit()
 
    call chncrv("both")
    call curve(xray,y1ray,n)
    call curve(xray,y2ray,n)
 
!   Statements for the legend
    call legini(cbuf,2,7)
    nx=nxposn(190.0)
    ny=nyposn(0.75)
    call legpos(nx,ny)
    call leglin(cbuf,"sin (x)",1)
    call leglin(cbuf,"cos (x)",2)
    call legtit("Legend")
    call legend(cbuf,3)
 
    call disfin()
end program exa_legend


