/****************************************************************/
/**                        DISLIN.H                            **/
/**                                                            **/
/** INCLUDE file for DISLIN C routines.                        **/
/**                                                            **/
/** Date     : 15.10.2005                                      **/
/** Functions: 618                                             **/
/** Version  : 9.0 / Double Precision                          **/
/****************************************************************/

#ifdef __cplusplus
  extern "C" {
#endif

void  abs3pt (double x, double y, double z, double *xp, double *yp);
void  addlab (char *cstr, double v, int itic, char *cax);
void  angle  (int ngrad);
void  arcell (int nx, int ny, int na, int nb, double a, double b, double t);
void  areaf  (int *nxray, int *nyray, int n);
void  autres (int ixdim, int iydim);
void  ax2grf (void);
void  ax3len (int nxl, int nyl, int nzl);
void  axclrs (int nclr, char *copt, char *cax);
void  axends (char *cstr, char *cax);
void  axgit  (void);
void  axis3d (double x3, double y3, double z3);
void  axsbgd (int nclr);
void  axslen (int nxl, int nyl);
void  axsorg (int nxa, int nya);
void  axspos (int nxa, int nya);
void  axsscl (char *cscl, char *cax);
void  axstyp (char *copt);
void  barbor (int iclr);
void  barclr (int ic1, int ic2, int ic3);
void  bargrp (int ngrp, double gap);
void  barmod (char *cmod, char *copt);
void  baropt (double xf, double a);
void  barpos (char *copt);
void  bars   (double *xray, double *y1ray, double *y2ray, int n);
void  bars3d (double *xray, double *yray, double *z1ray, double *z2ray,
             double *xwray, double *ywray, int *icray, int n);
void  bartyp (char *ctyp);
void  barwth (double factor);
void  basalf (char *calph);
void  basdat (int id, int im, int iy); 
void  bezier (double *xray, double *yray, int nray, double *x, double *y, int n);
short bitsi2 (int nbits, short mher, int iher, short mhin, int ihin);
int   bitsi4 (int nbits, int mher,int iher, int mhin, int ihin);
void  bmpfnt (char *copt);
void  box2d  (void);
void  box3d  (void);
void  center (void);
void  cgmbgd (double xr, double xg, double xb);
void  cgmpic (char *cstr);
void  cgmver (int nclr);
void  chaang (double angle);
void  chacod (char *copt);
void  chaspc (double xspc);
void  chawth (double xwth);
void  chnatt (void);
void  chncrv (char *copt);
void  chndot (void);
void  chndsh (void);
void  chnbar (char *copt);
void  chnpie (char *copt);
void  circ3p (double x1, double y1, double x2, double y2, double x3, double y3,
              double *xm, double *ym, double *r);
void  circle (int nx, int ny, int nr);
void  circsp (int nspc);
void  clip3d (char *ctyp);
int   closfl (int nu); 
void  clpbor (char *copt);
void  clpmod (char *copt);
void  clpwin (int nx, int ny, int nw, int nh);
void  clrcyc (int index, int iclr);
void  clrmod (char *cmode);
void  clswin (int id);
void  color  (char *col);
void  colran (int nca, int nce);
void  colray (double *zray, int *nray, int n);
void  complx (void);
void  conclr (int *nray, int n);
void  concrv (double *xray, double *yray, int n, double zlev);
void  confll (double *xray, double *yray, double *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri, 
              double *zlev, int nlev);
void  congap (double xfac);
void  conlab (char *clab);
void  conmat (double *zmat, int n, int m, double zlev);
void  conmod (double xfac, double xquot);
void  conn3d (double x, double y, double z);
void  connpt (double x, double y);
void  conpts (double *xray, int n, double *yray, int m, double *zmat, 
              double zlev, double *xpts, double *ypts, int maxpts,
              int *nray, int maxray, int *nlins);
void  conshd (double *xray, int n, double *yray, int m,
              double *zmat, double *zlev, int nlev);
void  contri (double *xray, double *yray, double *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri, double zlev);
void  contur (double *xray, int n, double *yray, int m,
              double *zmat, double zlev);
void  cross  (void);
void  crvmat (double *zmat, int n, int m, int ixpts, int iypts);
void  crvtri (double *xray, double *yray, double *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri);
void  csrmod (char *cmod, char *ckey);
int   csrpos (int *ix, int *iy);
void  csrpt1 (int *ix, int *iy);
void  csrpts (int *ix, int *iy, int nmax, int *n, int *iret);
void  csrmov (int *ix, int *iy, int nmax, int *n, int *iret);
void  csrtyp (char *copt);
void  csruni (char *copt);
void  curv3d (double *xray, double *yray, double *zray, int n);
void  curve  (double *xray, double *yray, int n);
void  curve3 (double *xray, double *yray, double *zray, int n);
void  curvmp (double *xray, double *yray, int n);
void  curvx3 (double *xray, double y, double *zray, int n);
void  curvy3 (double x, double *yray, double *zray, int n);
void  dash   (void);
void  dashl  (void);
void  dashm  (void);
void  dattim (char *cdate, char *ctime);
void  digits (int ndig, char *cax);
void  disalf (void);
void  disfin (void);
void  disini (void);
void  dot    (void);
void  dotl   (void);
void  duplx  (void);
int   dwgbut (char *cstr, int ival);
char *dwgfil (char *clab, char *cstr, char *cmask);
int   dwglis (char *clab, char *clis, int ilis);
void  dwgmsg (char *cstr);
char *dwgtxt (char *clab, char *cstr);
void  ellips (int nx, int ny, int na, int nb);
void  endgrf (void);
void  erase  (void);
void  errbar (double *x, double *y, double *err1, double *err2, int n);
void  errdev (char *cdev);
void  errfil (char *cfil);
void  errmod (char *cstr, char *copt);
void  eushft (char *cnat, char *cshf);
void  expzlb (char *cstr);
int   fcha   (double x, int ndig, char *cstr);
void  field  (double *xray, double *yray,
              double *uray, double *vray, int n, int ivec);
void  filbox (int nx, int ny, int nw, int nh);
void  filclr (char *copt);
void  filmod (char *cmod);
void  fixspc (double xfac);
void  flab3d (void);
int   flen   (double x, int ndig);
void  frame  (int nfrm);
void  frmclr  (int nclr);
void  frmess (int nfrm);
void  gapcrv (double xgap);
char *getalf (void);
int   getang (void);
int   getbpp (void);
void  getclp (int *nx, int *ny, int *nw, int *nh);
int   getclr (void);
void  getdig (int *nxdig, int *nydig, int *nzdig);
char *getdsp (void);
char *getfil (void);
void  getgrf (double *a, double *e, double *org, double *step, char *cax);
int   gethgt (void);
int   gethnm (void);
void  getind (int index, double *xr, double *xg, double *xb);
void  getlab (char *cx, char *cy, char *cz);
void  getlen (int *nxl, int *nyl, int *nzl);
int   getlev (void);
int   getlin (void);
int   getlit (double xp, double yp, double zp,
              double xn, double yn, double zn);
void  getmat (double *xray, double *yray, double *zray, int n, double *zmat,
              int nx, int ny, double zval, int *imat, double *wmat);
char *getmfl (void);
char *getmix (char *copt);
void  getor  (int *nx0, int *ny0);
void  getpag (int *nxpag, int *nypag);
long  getpat (void);
int   getplv (void);
void  getpos (int *nxa, int *nya);
void  getran (int *nca, int *nce);
void  getres (int *npb, int *nph);
void  getrgb (double *xr, double *xg, double *xb);
void  getscl (int *nxscl, int *nyscl, int *nzscl);
void  getscr (int *nwidth, int *nheight);
char *getshf (char *copt);
void  getsp1 (int *nxdis, int *nydis, int *nzdis);
void  getsp2 (int *nxdis, int *nydis, int *nzdis);
void  getsym (int *nxsym, int *nysym);
void  gettcl (int *nmaj, int *nmin);
void  gettic (int *nxtic, int *nytic, int *nztic);
int   gettyp (void);
void *getuni (void);
double getver (void);
void  getvk  (int *nv, int *nvfx, int *nvfy);
char *getvlt (void);
int   getwid (void);
void  getwin (int *ix, int *iy, int *nwidth, int *nheight);
int   getxid (char *copt);
void  gifmod (char *cmod, char *ckey);
int   gmxalf (char *copt, char *ca, char *cb);
void  gothic (void);
void  grace  (int ngrace);
void  graf   (double xa, double xe, double xorg, double xstp,
              double ya, double ye, double yorg, double ystp);
void  graf3  (double xa, double xe, double xorg, double xstp,
              double ya, double ye, double yorg, double ystp,
              double za, double ze, double zorg, double zstp);
void  graf3d (double xa, double xe, double xorg, double xstp,
              double ya, double ye, double yorg, double ystp,
              double za, double ze, double zorg, double zstp);
void  grafmp (double xa, double xe, double xorg, double xstp,
              double ya, double ye, double yorg, double ystp);
void  grdpol (int ixgrid, int iygrid);
void  grffin (void);
void  grfini (double x1, double y1, double z1,
              double x2, double y2, double z2, 
              double x3, double y3, double z3);
void  grid   (int ixgrid, int iygrid);
void  grid3d (int ixgrid, int iygrid, char *copt);
void  gridmp (int ixgrid, int iygrid);
int   gwgatt (int id, char *copt);
int   gwgbox (int id);
int   gwgbut (int id);
void  gwgfil (int id, char *cfile);
int   gwglis (int id);
double gwgscl (int id);
void  gwgtxt (int id, char *ctext);
int   gwgxid (int id);
void  height (int nhchar);
void  helve  (void);
void  helves (void);
void  histog (double *xray, int n, double *x, double *y, int *m);
void  hname  (int nhchar);
void  hsvrgb (double  xh, double  xs, double  xv, 
              double *xr, double *xg, double *xb);
void  hsymbl (int nhsym);
void  htitle (int nhtit);
void  hwfont (void);
void  hworig (int nx, int ny);
void  hwpage (int nw, int nh);
void  imgbox (int nx, int ny, int nw, int nh);
void  imgclp (int nx, int ny, int nw, int nh);
void  imgfin (void);
void  imgfmt (char *copt);
void  imgini (void);
void  imgmod (char *copt);
void  imgsiz (int nw, int nh);
void  inccrv (int ncrv);
int   incdat (int id, int im, int iy);
void  incfil (char *cfil);
void  incmrk (int nmrk);
int   indrgb (double xr, double xg, double xb);
void  intax  (void);
int   intcha (int nx, char *cstr);
int   intlen (int nx);
int   intrgb (double xr, double xg, double xb);
void  itmcat (char *clis, char *cstr);
int   itmcnt (char *clis);
char *itmstr (char *clis, int nlis);
void  labclr (int iclr, char *copt);
void  labdig (int ndig, char *cax);
void  labdis (int ndis, char *cax);
void  labels (char *clab, char *cax);
void  labjus (char *copt, char *cax);
void  labl3d (char *copt);
void  labmod (char *ckey, char *cval, char *cax);
void  labpos (char *cpos, char *cax);
void  labtyp (char *ctyp, char *cax);
void  legclr (void);
void  legend (char *cbuf, int ncor);
void  legini (char *cbuf, int nlin, int nmaxln);
void  leglin (char *cbuf, char *cstr, int ilin);
void  legopt (double x1, double x2, double x3);
void  legpat (int ityp, int ithk, int isym, long ipat, int iclr, int ilin);
void  legpos (int nx, int ny);
void  legtit (char *cstr);
void  lfttit (void);
void  light  (char *copt);
void  lincyc (int index, int ityp);
void  line   (int nx, int ny, int nu, int nv);
void  linesp (double xfac);
void  lintyp (int ntyp);
void  linwid (int i);
void  litmod (int id, char *copt);
void  litop3 (int id, double xr, double xg, double xb, char *copt);
void  litopt (int id, double xval, char *copt);
void  litpos (int id, double x, double y, double z, char *copt);
void  lncap  (char *copt);
void  lnjoin (char *copt);
void  lnmlt  (double x);
void  logtic (char *cmod);
void  lsechk (char *cmod);
void  mapbas (char *cmod);
void  mapfil (char *cfil, char *copt);
void  maplev (char *cmod);
void  mapmod (char *cmod);
void  mappol (double xpol, double ypol);
void  mapref (double ylower, double yupper);
void  mapsph (double xrad);
void  marker (int nsym);
void  matop3 (double xr, double xg, double xb, char *copt);
void  matopt (double xval, char *copt);
void  mdfmat (int nx, int ny, double weight);
void  messag (char *cstr, int nx, int ny);
void  metafl (char *cstr);
void  mixalf (void);
void  mixleg (void);
double moment (double *xray, int n, char *copt);
void  mpaepl (int i);
void  mplang (double x);
void  mplclr (int nbg, int nfg);
void  mplpos (int nx, int ny);
void  mplsiz (int nsize);
void  mpslogo (int nx, int ny, int nsize, char *copt);
void  msgbox (char *cstr);
void  mshclr (int ic);
void  mylab  (char *cstr, int itick, char *cax);
void  myline (int *nray, int n);
void  mypat  (int iang, int itype, int idens, int icross);
void  mysymb (double *xray, double *yray, int n, int isym, int iflag);
void  myvlt  (double *xr, double *xg, double *xb, int n);
void  namdis (int ndis, char *cax);
void  name   (char *cstr, char *cax);
void  namjus (char *copt, char *cax);
void  neglog (double eps);
void  newmix (void);
void  newpag (void);
int   nlmess (char *cstr);
int   nlnumb (double x, int ndig);
void  noarln (void);
void  nobar  (void);
void  nobgd  (void);
void  nochek (void);
void  noclip (void);
void  nofill (void);
void  nograf (void);
void  nohide (void);
void  noline (char *cax);
void  number (double x, int ndig, int nx, int ny);
void  numfmt (char *copt);
void  numode (char *cdec, char *cgrp, char *cpos, char *cfix);
int   nwkday (int id, int im, int iy);
int   nxlegn (char *cbuf);
int   nxposn (double x);
int   nylegn (char *cbuf);
int   nyposn (double y);
int   nzposn (double z);
int   openfl (char *cfil, int nu, int irw); 
void  opnwin (int id);
void  origin (int nx0, int ny0);
void  page   (int nw, int nh);
void  pagera (void);
void  pagfll (int nclr);
void  paghdr (char *cstr1, char *cstr2, int iopt, int idir);
void  pagmod (char *cmod);
void  pagorg (char *cpos);
void  patcyc (int index, long ipat);
int   pdfbuf (char *cbuf, int nmax);
void  pdfmod (char *cmod, char *ckey);
void  pdfmrk (char *cstr, char *copt);
void  penwid (double x);
void  pie    (int nxm, int nym, int nr, double a, double b);
void  piebor (int iclr);
void  pieclr (int *ic1, int *ic2, int n);
void  pieexp (void);
void  piegrf (char *cbuf, int nlin, double *xray, int nseg);
void  pielab (char *clab, char *cpos);
void  pieopt (double xf, double a);
void  pietyp (char *ctyp);
void  pievec (int ivec, char *copt);
void  pngmod (char *cmod, char *ckey);
void  point  (int nx, int ny, int nb, int nh, int ncol);
void  polar  (double xe, double xorg, double xstp, double yorg, double ystp);
void  polcrv (char *cpol);
void  polmod (char *cpos, char *cdir);
void  pos2pt (double x, double y, double *xp, double *yp);
void  pos3pt (double x, double y, double z, double *xp, double *yp, double *zp);
int   posifl (int nu, int nbyte); 
void  projct (char *cproj);
void  psfont (char *cfont);
void  psmode (char *cmod);
void  qplot  (double *xray, double *yray, int n);
void  qplsca (double *xray, double *yray, int n);
void  qplpie (double *xray, int n);
void  qplbar (double *yray, int n);
void  qplclr (double *zmat, int n, int m);
void  qplsur (double *zmat, int n, int m);
void  qplcon (double *zmat, int n, int m, int nlv);
int   rbfpng (char *cbuf, int nmax);
void  rbmp   (char *cfil);
int   readfl (int nu, unsigned char *cbuf, int nbyte); 
void  reawgt (void);
void  recfll (int nx, int ny, int nw, int nh, int ncol);
void  rectan (int nx, int ny, int nw, int nh);
void  rel3pt (double x, double y, double z, double *xp, double *yp);
void  resatt (void);
void  reset  (char *cname);
void  revscr (void);
void  rgbhsv (double xr, double xg, double xb, double *xh, double *xs, double *xv);
void  rgif   (char *cfil);
void  rgtlab (void);
void  rimage (char *cfil);
void  rlarc  (double xm, double ym, double xa, double xb,
              double a,  double b,  double t);
void  rlarea (double *xray, double *yray, int n);
void  rlcirc (double xm, double ym, double r);
void  rlconn (double x, double y);
void  rlell  (double xm, double ym, double a, double b);
void  rline  (double x, double y, double u, double v);
void  rlmess (char *cstr, double x, double y);
void  rlnumb (double x, int ndig, double xp, double yp);
void  rlpie  (double xm, double ym, double r, double a, double b);
void  rlpoin (double x, double y, int nb, int nh, int ncol);
void  rlrec  (double x, double y, double xw, double xh);
void  rlrnd  (double x, double y, double xb, double xh, int irnd);
void  rlsec  (double xm, double ym, double r1, double r2,
              double a,  double b,  int ncol);
void  rlstrt (double x, double y);
void  rlsymb (int nsym, double x, double y);
void  rlvec  (double x1, double y1, double x2, double y2, int ivec);
void  rlwind (double xk, double x, double y, int nwidth, double a);
void  rndrec (int nx, int ny, int nb, int nh, int irnd);
void  rpixel (int ix, int iy, int *iclr);
void  rpixls (unsigned char *iray, int ix, int iy, int nw, int nh);
void  rpng   (char *cfil);
void  rppm   (char *cfil);
void  rpxrow (unsigned char *iray, int ix, int iy, int n);
void  rtiff  (char *cfil);
void  rvynam (void);
void  scale  (char *cscl, char *cax);
void  sclfac (double xfac);
void  sclmod (char *cmode);
void  scrmod (char *cmode);
void  sector (int nx, int ny, int nr1, int nr2, double a, double b, int ncol);
void  selwin (int id);
void  sendbf (void);
void  sendmb (void);
void  sendok (void);
void  serif  (void);
void  setbas (double xfac);
void  setcbk (void (*callbck) (double *x, double *y), char *copt);
void  setclr (int ncol);
void  setcsr (char *copt);
void  setexp (double fexp);
void  setfil (char *cfil);
void  setgrf (char *c1, char *c2, char *c3, char *c4);
void  setind (int index, double xr, double xg, double xb);
void  setmix (char *cstr, char *cmix);
void  setpag (char *cpag);
void  setres (int npb, int nph);
void  setrgb (double xr, double xg, double xb);
void  setscl (double *xray, int n, char *cax);
void  setvlt (char *cvlt);
void  setxid (int id, char *copt);
void  shdafr (int *inray, long *ipray, int *icray, int n);
void  shdcha (void);
void  shdcrv (double *x1ray, double *y1ray, int n1,
              double *x2ray, double *y2ray, int n2);
void  shdeur (int *inray, long *ipray, int *icray, int n);
void  shdmap (char *cmap);
void  shdmod (char *copt, char *ctyp);
void  shdpat (long ipat);
void  shdusa (int *inray, long *ipray, int *icray, int n);
void  shield (char *carea, char *cmode);
void  shlcir (int nx, int ny, int nr);
void  shldel (int id);
void  shlell (int nx, int ny, int na, int nb, double t);
int   shlind (void);
void  shlpie (int nx, int ny, int nr, double a, double b);
void  shlpol (int *nxray, int *nyray, int n);
void  shlrct (int nx, int ny, int nw, int nh, double t);
void  shlrec (int nx, int ny, int nw, int nh);
void  shlres (int n);
void  shlsur (void);
void  shlvis (int id, char *cmode);
void  simplx (void);
int   skipfl (int nu, int nbyte); 
void  smxalf (char *calph, char *c1, char *c2, int n);
void  solid  (void);
void  sortr1 (double *xray, int n, char *copt);
void  sortr2 (double *xray, double *yray, int n, char *copt);
void  sphe3d (double xm, double ym, double zm, double r, int n, int m);
void  spline (double *xray,  double *yray,  int n,
              double *xsray, double *ysray, int *nspl);
void  splmod (int ngrad, int npts);
void  strt3d (double x, double y, double z);
void  strtpt (double x, double y);
void  surclr (int ictop, int icbot);
void  surfce (double *xray, int n, double *yray, int m, double *zmat);
void  surfcp (double (*zfun)(double x, double y, int i), 
                         double a1, double a2, double astp,
                         double b1, double b2, double bstp);
void  surfun (double (*zfun)(double x, double y), int ixpts, double xdel, 
                     int iypts, double ydel);
void  suriso (double *xray, int nx, double *yray, int ny, double *zray, int nz,
              double *wmat, double wlev);
void  surmat (double *zmat, int nx, int ny, int ixpts, int iypts);
void  surmsh (char *copt);
void  suropt (char *copt);
void  surshd (double *xray, int n, double *yray, int m, double *zmat);
void  sursze (double xmin, double xmax, double ymin, double ymax);
void  surtri (double *xray, double *yray, double *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri);
void  survis (char *cvis);
void  swapi2 (short *iray, int n);
void  swapi4 (int *iray, int n);
void  swgatt (int id, char *cval, char *copt);
void  swgbox (int ip, int ival);
void  swgbut (int ip, int ival);
void  swgcb  (int id, void (*callbck) (int i, int *ir), int *iray);
void  swgcbk (int id, void (*callbck) (int i));
void  swgclr (double xr, double xg, double xb, char *copt);
void  swgdrw (double x);
void  swgfil (int ip, char *cval);
void  swgfnt (char *cfnt, int n);
void  swgfoc (int id);
void  swghlp (char *cstr);
void  swgjus (char *ctyp, char *cwidg);
void  swglis (int ip, int ival);
void  swgmix (char *c, char *cstr);
void  swgmod (char *cmod);
void  swgmrg (int ival, char *cstr);
void  swgoff (int nx, int ny);
void  swgopt (char *cval, char *copt);
void  swgpop (char *copt);
void  swgpos (int nx, int ny);
void  swgscl (int ip, double xval);
void  swgsiz (int nx, int ny);
void  swgspc (double xw, double xh);
void  swgstp (double step);
void  swgtit (char *ctit);
void  swgtxt (int ip, char *cval);
void  swgtyp (char *ctyp, char *cwidg);
void  swgwin (int nx, int ny, int nw, int nh);
void  swgwth (int nchar);
void  symbol (int nsym, int nx, int ny);
void  symfil (char *cdev, char *cstat);
void  symrot (double angle);
int   tellfl (int nu); 
void  texmod (char *copt);
void  texopt (char *copt, char *ctyp);
void  thkcrv (int nthk);
void  ticks  (int itick, char *cax);
void  ticlen (int nmaj, int nmin);
void  ticmod (char *copt, char *cax);
void  ticpos (char *cpos, char *cax);
void  tifmod (int n, char *cval, char *copt);
void  tiforg (int nx, int ny);
void  tifwin (int nx, int ny, int nw, int nh);
void  timopt (void);
void  titjus (char *copt);
void  title  (void);
void  titlin (char *cstr, int n);
void  titpos (char *copt);
void  trfco1 (double *xray, int n, char *cfrom, char *cto); 
void  trfco2 (double *xray, double *yray, int n, char *cfrom, char *cto); 
void  trfco3 (double *xray, double *yray, double *zray, int n, 
              char *cfrom, char *cto);
void  trfdat (int ndays, int *id, int *im, int *iy); 
void  trfmat (double *zmat, int nx, int ny, double *zmat2, int nx2, int ny2);
void  trfrel (double *xray, double *yray, int n);
void  trfres (void);
void  trfrot (double xang, int nx, int ny);
void  trfscl (double xscl, double yscl);
void  trfshf (int nx, int ny);
int   triang (double *xray, double *yray, int n, int *i1ray, int *i2ray,
              int *i3ray, int nmax); 
void  trifll (double *xray, double *yray);
void  triplx (void);
void  tripts (double *xray, double *yray, double *zray, int n, int *i1ray, 
              int *i2ray, int *i3ray, int ntri, double zlev, double *xpts,
              double *ypts, int maxpts, int *nptray, int maxray, int *nlins);
int   trmlen (char *cstr);
void  txtjus (char *copt);
void  unit   (void *fp);
void  units  (char *copt);
void  upstr  (char *cstr);
void  vang3d (double a);
void  vclp3d (double x1, double x2);
void  vector (int nx1, int ny1, int nx2, int ny2, int ivec);
void  vectr3 (double x1, double y1, double z1,
              double x2, double y2, double z2, int ivec);
void  vfoc3d (double x, double y, double z, char *cview);
void  view3d (double xvu, double yvu, double zvu, char *cvu);
void  vkxbar (int nvfx);
void  vkybar (int nvfy);
void  vkytit (int nvfy);
void  vltfil (char *cfl, char *copt);
void  vup3d  (double a);
int   wgapp  (int ip, char *clab);
int   wgbas  (int ip, char *ctyp);
int   wgbox  (int ip, char *cstr, int isel);
int   wgbut  (int ip, char *cstr, int ival);
int   wgcmd  (int ip, char *clab, char *cmd);
int   wgdlis (int ip, char *cstr, int isel);
int   wgdraw (int ip);
int   wgfil  (int ip, char *clab, char *cstr, char *cmask);
void  wgfin  (void);
int   wgini  (char *ctyp);
int   wglab  (int ip, char *cstr);
int   wglis  (int ip, char *cstr, int isel);
int   wgltxt (int ip, char *clab, char *ctext, int iper);
int   wgok   (int ip);
int   wgpbut (int ip, char *clab);
int   wgpop  (int ip, char *clab);
int   wgquit (int ip);
int   wgscl  (int ip, char *cstr, double x1, double x2, double xval, int ndez);
int   wgstxt (int ip, int nsize, int nmax);
int   wgtxt  (int ip, char *cstr);
void  widbar (int nzb);
void  wimage (char *cfil);  
void  winapp (char *copt);  
void  windbr (double xk, int nx, int ny, int nwidth, double a);
void  window (int nx, int ny, int nw, int nh);
void  winfin (int iopt);
void  winfnt (char *cfont);
int   winid  (void);
void  winini (void *p1, void *p2, int i1, int i2);
void  winkey (char *copt);
void  winmod (char *copt);
void  winopt (int iopt, char *copt);
void  winsiz (int nw, int nh);
void  wintit (char *cstr);
void  wmfmod (char *cmod, char *ckey);
void  world  (void);
void  wpixel (int ix, int iy, int iclr);
void  wpixls (unsigned char *iray, int ix, int iy, int nw, int nh);
void  wpxrow (unsigned char *iray, int ix, int iy, int n);
int   writfl (int nu, unsigned char *cbuf, int nbyte); 
void  wtiff  (char *cfil);
void  x11fnt (char *cfont, char *copt);
void  x11mod (char *copt);
double x2dpos (double x, double y);
double x3dabs (double x, double y, double z);
double x3dpos (double x, double y, double z);
double x3drel (double x, double y, double z);
void  xaxgit (void);
void  xaxis  (double xa, double xe, double xorg, double xstp, 
              int nl, char *cstr, int it, int nx, int ny);
void  xaxlg  (double xa, double xe, double xorg, double xstp,
              int nl, char *cstr, int it, int nx, int ny);
void  xaxmap (double xa, double xe, double xorg, double xstp,
              char *cstr, int it, int ny);
void  xcross (void);
void  xdraw  (double x, double y);
double xinvrs (int n);
void  xmove  (double x, double y);
double xposn  (double x);
double y2dpos (double x, double y);
double y3dabs (double x, double y, double z);
double y3dpos (double x, double y, double z);
double y3drel (double x, double y, double z);
void  yaxgit (void);
void  yaxis  (double ya, double ye, double yor, double ystp, 
              int nl, char *cstr, int it, int nx, int ny);
void  yaxlg  (double ya, double ye, double yor, double ystp,
              int nl, char *cstr, int it, int nx, int ny);
void  yaxmap (double ya, double ye, double yor, double ystp,
              char *cstr, int it, int ny);
void  ycross (void);
double yinvrs (int n);
double yposn  (double y);
double z3dpos (double x, double y, double z);
void  zaxis  (double za, double ze, double zor, double zstp, 
              int nl, char *cstr, int it, int id, int nx, int ny);
void  zaxlg  (double za, double ze, double zor, double zstp, 
              int nl, char *cstr, int it, int id, int nx, int ny);
void  zbffin (void);
int   zbfini (void);
void  zbflin (double x1, double y1, double z1, double x2, double y2, double z2);
void  zbftri (double *x, double *y, double *z, int *ic);
void  zscale (double za, double ze);

#ifdef __cplusplus
  }
#endif
