/**************************************************************************

    cfgdlg.cpp  - The dialog to configure the pass and stop values 
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#include "cfgdlg.moc"
#include <qpushbt.h>
#include <qlistbox.h>
#include <qlabel.h> 
#include <qfiledlg.h>
#include <kapp.h>
#include <qlined.h>
#include <qvalidator.h>
#include <values.h>
#include <stdlib.h>

ConfigDialog::ConfigDialog(double pv,double sv, QWidget *parent,const char *name) : QDialog(parent,name,TRUE)
{
passvalue=pv;
stopvalue=sv;
setCaption("Configura los valores de paso y de detencion");
setMinimumSize(360,240);
setMaximumSize(360,240);
ok=new QPushButton("OK",this);
ok->setGeometry(140,200,100,30);
connect(ok,SIGNAL(clicked()),SLOT(accept()) );
cancel=new QPushButton("Cancelar",this);
cancel->setGeometry(250,200,100,30);
connect(cancel,SIGNAL(clicked()),SLOT(reject()) );

char tmp[100];
sprintf(tmp,"%g",passvalue);

label=new QLabel("Valor de paso :",this);
label->adjustSize();
label->move(10,10);
ledit_pv=new QLineEdit(this,"pv");
ledit_pv->setGeometry(10,30,340,30);
valid=new QDoubleValidator(-MAXDOUBLE,MAXDOUBLE,5,this,"validate");
ledit_pv->setValidator(valid);
ledit_pv->setText(tmp);

sprintf(tmp,"%g",stopvalue);
label2=new QLabel("Valor de detencion :",this);
label2->adjustSize();
label2->move(10,70);
ledit_sv=new QLineEdit(this,"sv");
ledit_sv->setGeometry(10,90,340,30);
valid2=new QDoubleValidator(-MAXDOUBLE,MAXDOUBLE,5,this,"validate2");
ledit_sv->setValidator(valid);
ledit_sv->setText(tmp);
};

void ConfigDialog::accept()
{
passvalue=strtod(ledit_pv->text(),NULL);
stopvalue=strtod(ledit_sv->text(),NULL);
QDialog::accept();
};

double ConfigDialog::passvalue=1;
double ConfigDialog::stopvalue=0;
