/**************************************************************************

    fft1d.cc  - The 1 dimension FFT algorithm from Dr Dobbs Journal
		changed to clarify and optimize a bit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/

#include "fft1d.h"
#include <sys/types.h>
#include <stdio.h>

static double CosArray[28]=
{ /* cos (-2pi/N) for N=2,4,8,...,16384 */
-1.00000000000000,  0.00000000000000,  0.70710678118655,
 0.92387953251129,  0.98078528040323,  0.99518472667220,
 0.99879545620517,  0.99969881869620,  0.99992470183914,
 0.99998117528260,  0.99999529380958,  0.99999882345170,
 0.99999970586288,  0.99999992646572,
 /* cos (2pi/N) for N=2,4,8...16384 */
-1.00000000000000,  0.00000000000000,  0.70710678118655,
 0.92387953251129,  0.98078528040323,  0.99518472667220,
 0.99879545620517,  0.99969881869620,  0.99992470183914,
 0.99998117528260,  0.99999529380958,  0.99999882345170,
 0.99999970586288,  0.99999992646572
};

static double SinArray[28]=
{ /* sin (-2pi/N) for N=2,4,8,...,16384 */
 0.00000000000000, -1.00000000000000, -0.70710678118655,
-0.38268343236509, -0.19509032201613, -0.09801714032956,
-0.04906767432742, -0.02454122852291, -0.01227153828572,
-0.00613588464915, -0.00306795676297, -0.00153398018628,
-0.00076699031874, -0.00038349518757,
 /* sin (2pi/N) for N=2,4,8,...,16384 */
 0.00000000000000,  1.00000000000000,  0.70710678118655,
 0.38268343236509,  0.19509032201613,  0.09801714032956,
 0.04906767432742,  0.02454122852291,  0.01227153828572,
 0.00613588464915,  0.00306795676297,  0.00153398018628,
 0.00076699031874,  0.00038349518757
};

u_int ShuffleIndex(u_int i, int WordLength)
{
u_int NewIndex;
u_char BitNr;
NewIndex=0;
for (BitNr=0;BitNr<=WordLength-1;BitNr++)
  {
  NewIndex=NewIndex << 1;
  if ((i&1)!=0) NewIndex = NewIndex+1;
  i = i >> 1;
  };
  return NewIndex;
};

void Shuffle2Arr(double_complex *a, int bitlength)
{
u_int indexOld,indexNew;
double_complex temp;
u_int  N;
int bitlengthtemp;

bitlengthtemp=bitlength;
N=1;
do 
  {
  N=N*2;
  bitlength=bitlength-1;
  } while (bitlength > 0);

for (indexOld=0; indexOld <= N-1 ;indexOld++)
  {
  indexNew = ShuffleIndex(indexOld,bitlengthtemp);
  if (indexNew > indexOld)
     {
     temp=a[indexOld];
     a[indexOld]=a[indexNew];
     a[indexNew]=temp;
     };
  };

}; 


void FFT( double_complex *data, int Pwr, int Dir)
{
int pwrhelp;
int N;
int Section;
int AngleCounter;
int FlyDistance;
int FlyCount;
int index1,index2;
double_complex temp;
double scale;
double_complex Q;

Shuffle2Arr(data,Pwr);

pwrhelp=Pwr;
N=1;
do
  {
  N*=2;
  pwrhelp--;
  } while (pwrhelp>0);

if (Dir>=1) AngleCounter=0;
	else AngleCounter=14;
Section=1;
while (Section<N)
  {
  FlyDistance = 2*Section;
  double_complex giro(CosArray[AngleCounter],SinArray[AngleCounter]);
  Q*=0;
  Q+=1;
  for (FlyCount=0;FlyCount<=Section-1;FlyCount++)
     {
     index1=FlyCount;
     do
       {
       index2 = index1 + Section;
       temp= Q*data[index2];
       data[index2]=data[index1]-temp;
       data[index1]=data[index1]+temp;
       index1=index1+FlyDistance;
       } while (index1 <= (N-1));
     Q=Q*giro;

     };
  Section*=2;
  AngleCounter++;
  };
if (Dir<=0)
  {
  scale = 1.0/N;
  for (index1=0;index1<=N-1;index1++)
     {
     data[index1]*=scale;
     };
  };

};
