/**************************************************************************

    fft2d.cc  - The 2D FFT algorithm (based in the 1D FFT) 
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#include "fft2d.h"
#include "fft1d.h"
#include <stdio.h>
#include <unistd.h>
#include "pow2.h"


double_complex *Allocate_complex_array(int l)
{
double_complex *data=new double_complex[l];
if (data==NULL)
   {
   printf("No memory\n");
   exit(1);
   };
return data;
};

void FFT2D(double_complex **in, double_complex **out,int w,int h, int Dir)
{
printf("Preparing data ...\n");
double_complex **temp;
int i,j;
int w_bits,h_bits;
w_bits=(int)(ceil(log(w)/log(2)));
h_bits=(int)(ceil(log(h)/log(2)));
//printf("w : %d,%d, h : %d,%d\n",w,w_bits,h,h_bits);
temp=new double_complex*[h];

for (i=0;i<h;i++)
   {
   temp[i]=Allocate_complex_array(w);
   for (j=0;j<w;j++)
      {
      temp[i][j]=in[i][j];
      };
   };

printf("Doing Horiz FFT ...\n");

for (i=0;i<h;i++)
   {
//   printf("Row %d\n",i);
   FFT(temp[i],w_bits,Dir);
   };

printf("Preparing 2nd data ...\n");

double_complex **temp2=new double_complex*[w];
for (i=0;i<w;i++)
   {
   temp2[i]=Allocate_complex_array(h);
   for (j=0;j<h;j++)
      {
      temp2[i][j]=temp[j][i];
      };
   };

printf("Doing Vert FFT ...\n");

for (i=0;i<w;i++)
   {
//   printf("Column %d\n",i);
   FFT(temp2[i],h_bits,Dir);
   };

for (i=0;i<h;i++)
   {
   for (j=0;j<w;j++)
      out[i][j]=temp2[j][i];
   };

printf("Deallocating memory ...\n");
for (i=0;i<w;i++)
   {
   delete temp2[i];
   };
delete temp2;
for (i=0;i<h;i++)
   {
   delete temp[i];
   };
delete temp;


};


void FFT2D_real(u_int **in, double_complex **out,int w,int h, int Dir)
{
w=is2pow(w);
h=is2pow(h);
printf("Converting real to complex array... \n");
double_complex **input;
input=new double_complex*[h];
int i,j;
for (i=0;i<h;i++)
   {
   input[i]=Allocate_complex_array(w);
   for (j=0;j<w;j++)
      input[i][j]=in[i][j];
   };

FFT2D(input,out,w,h,Dir);

for (i=0;i<h;i++)
   delete input[i];
delete input;
};

void FFT2D_real(double_complex **in, u_int **out,int w,int h, int Dir)
{
w=is2pow(w);
h=is2pow(h);
printf("Allocating temp complex array ... \n");
double_complex **output;
output=new double_complex*[h];
int i,j;
for (i=0;i<h;i++)
   output[i]=Allocate_complex_array(w);

printf("Doing 2D FFT ...\n");
FFT2D(in,output,w,h,Dir);

printf("Converting real to complex array... \n");
for (i=0;i<h;i++)
   for (j=0;j<w;j++)
      out[i][j]=(u_int)(output[i][j].real());

for (i=0;i<h;i++)
   delete output[i];
delete output;
}; 
