/**************************************************************************

    kclient.cpp  - The main client widget of kfourier 
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#include <qkeycode.h>
#include <stdio.h>
#include <qfiledlg.h>
#include <kapp.h>
#include <qstring.h>
#include <unistd.h>
#include <kmsgbox.h>
#include <sys/signal.h>
#include <qlcdnum.h>
#include <kurl.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qimage.h>
#include "tfourier.h"
#include "fft2d.h"
#include <stdlib.h>
#include "pow2.h"
#include "cfgdlg.h"

#include "kclient.moc"

// Define only one of next two:
#define SHOW_NORM
//#define SHOW_ANGLE


#define SCALE_RIGHT

kClient::kClient(QWidget *parent,const char *name)
	:QWidget(parent,name)
{
type_of_decomposition=0;
source_img=new QPixmap();
fourier_img=new QPixmap();
target_img=new QPixmap();
for (int i=0;i<3;i++)
   {
   source_imgs[i]=new QPixmap();
   fourier_imgs[i]=new QPixmap();
   target_imgs[i]=new QPixmap();
   source_data[i]=NULL;
   fourier_data[i]=NULL;
   fourier_u_int_data[i]=NULL;
   target_data[i]=NULL;
   };
drawmode=0;
placecenter=0;
saveimage=0;
cuad[0]=cuad[1]=cuad[2]=cuad[3]=cuad[4]=1;
pass_value=1.0;
stop_value=0.0;
fourier_ratio[0]=fourier_ratio[1]=fourier_ratio[2]=-1;
setMouseTracking(TRUE);
};

kClient::~kClient()
{
setMouseTracking(FALSE);
deallocate_all_memory();
for (int i=0;i<3;i++)
   {
   delete target_imgs[i];
   delete fourier_imgs[i];
   delete source_imgs[i];
   };
delete target_img;
delete fourier_img;
delete source_img;
};

void kClient::deallocate_all_memory(void)
{
printf("Releasing memory ...\n");
int w=imgwidth;
int h=imgheight;
for (int i=0;i<3;i++)
   {
   if (source_data[i]!=NULL) DeallocateIntImg(w,h,source_data[i]);
   source_data[i]=NULL;
   if (fourier_data[i]!=NULL) DeallocateComplexImg(w,h,fourier_data[i]);
   fourier_data[i]=NULL;
   if (fourier_u_int_data[i]!=NULL) DeallocateIntImg(w,h,fourier_u_int_data[i]);
   fourier_u_int_data[i]=NULL;
   if (target_data[i]!=NULL) DeallocateIntImg(w,h,target_data[i]);
   target_data[i]=NULL;
   };
};

void kClient::clearImages(void)
{
for (int i=0;i<3;i++)
   {
   delete target_imgs[i];
   delete fourier_imgs[i];
   delete source_imgs[i];
   source_imgs[i]=new QPixmap();
   fourier_imgs[i]=new QPixmap();
   target_imgs[i]=new QPixmap();
   };
delete target_img;
delete fourier_img;
delete source_img;
source_img=new QPixmap();
fourier_img=new QPixmap();
target_img=new QPixmap();

};

int kClient::openFile(char *filename)
{
deallocate_all_memory();
clearImages();
printf("Open : %s\n",filename);
source_img->load(filename);
imgwidth=source_img->width();
imgheight=source_img->height();
cx=is2pow(imgwidth)/2;
cy=is2pow(imgheight)/2;
decompose();
repaint(TRUE);
printf("file opened\n");
return 0;
};

void kClient::reallySaveImage(int col,int p)
{
char name[200];
name[0]=0;
QString filename;
filename=QFileDialog::getSaveFileName(0,"*.*",this,name);
if (!filename.isNull())
        {
	QPixmap *qpxmp;
	if (col==0)
	{
		switch (p)
		{
		case (0) : qpxmp=source_imgs[0];break;
		case (1) : qpxmp=source_imgs[1];break;
		case (2) : qpxmp=source_imgs[2];break;
		case (3) : qpxmp=source_img;break;
		default : return;
		};
	}
	else if (col==1)
	{
		switch (p)
		{
		case (0) : qpxmp=fourier_imgs[0];break;
		case (1) : qpxmp=fourier_imgs[1];break;
		case (2) : qpxmp=fourier_imgs[2];break;
		case (3) : qpxmp=fourier_img;break;
		default : return;
		};
	}
 	else if (col==2)
	{
		switch (p)
		{
		case (0) : qpxmp=target_imgs[0];break;
		case (1) : qpxmp=target_imgs[1];break;
		case (2) : qpxmp=target_imgs[2];break;
		case (3) : qpxmp=target_img;break;
		default : return;
		};
	}
	else return;
	qpxmp->save((char *)(const char *)filename,
				((saveimageformat==0)?("XPM"):("BMP")));
	};
  
};

void kClient::paintEvent(QPaintEvent *)
{
QPainter *qpaint=new QPainter(this);
int w=is2pow(imgwidth);
int h=is2pow(imgheight);

qpaint->drawPixmap(0,0,*source_img);
qpaint->drawPixmap(w+5,0,*fourier_img);
qpaint->drawPixmap((w+5)*2,0,*target_img);
int y=h+5;
for (int i=0;i<3;i++)
   {
   qpaint->drawPixmap(0,y,*source_imgs[i]);
   qpaint->drawPixmap(w+5,y,*fourier_imgs[i]);
   qpaint->drawPixmap((w+5)*2,y,*target_imgs[i]);
   y+=h+5;
   };
delete qpaint;
}; 


void kClient::convertQPixmapToInt(QPixmap *qpixmap,u_int **out,int rgb)
// rgb indicates which colour to put in output (0 R, 1 G, 2 B)
// or if type_of_decomposition is 1 (HSV) then rgb indicates (0 H, 1 S, 2 V) 
{
QImage img;
img=*qpixmap;
QColor col;
int i,j;
if (type_of_decomposition==0)
{
if (rgb==0)
   {
   for (j=0;j<img.height();j++)
      for (i=0;i<img.width();i++)
	{
	col.setRgb(img.pixel(i,j));
	out[j][i]=col.red();
	};
   };
if (rgb==1)
   {
   for (j=0;j<img.height();j++)
      for (i=0;i<img.width();i++)
	{
	col.setRgb(img.pixel(i,j));
	out[j][i]=col.green();
	};
   };
if (rgb==2)
   {
   for (j=0;j<img.height();j++)
      for (i=0;i<img.width();i++)
	{
	col.setRgb(img.pixel(i,j));
	out[j][i]=col.blue();
	};
   };
} else // HSV
{
int h,s,v;
if (rgb==0)
   {
   for (j=0;j<img.height();j++)
      for (i=0;i<img.width();i++)
	{
	col.setRgb(img.pixel(i,j));
        col.hsv(&h,&s,&v);
	out[j][i]=h;
	};
   };
if (rgb==1)
   {
   for (j=0;j<img.height();j++)
      for (i=0;i<img.width();i++)
	{
	col.setRgb(img.pixel(i,j));
        col.hsv(&h,&s,&v);
	out[j][i]=s;
	};
   };
if (rgb==2)
   {
   for (j=0;j<img.height();j++)
      for (i=0;i<img.width();i++)
	{
	col.setRgb(img.pixel(i,j));
        col.hsv(&h,&s,&v);
	out[j][i]=v;
	};
   };

};
};


void kClient::convertIntToQPixmap(int w,int h,u_int **r,u_int **g,u_int **b,QPixmap *out)
{
QImage img(w,h,32);
QColor col;
if (type_of_decomposition==0)
{
for (int j=0;j<h;j++)
   for (int i=0;i<w;i++)
      {
      col.setRgb((r==NULL)?0:(r[j][i]%256),(g==NULL)?0:(g[j][i]%256),(b==NULL)?0:(b[j][i]%256));
      img.setPixel(i,j,col.rgb());
      };
} else
{
double ratio=255.0/360.0;
int temp;
for (int j=0;j<h;j++)
   for (int i=0;i<w;i++)
      {
      if ((r==NULL)&&(g==NULL)) 
	{
	temp=b[j][i]%256;
	col.setRgb(temp,temp,temp);
	}
      else if ((r==NULL)&&(b==NULL)) 
	{
	temp=g[j][i]%256;
	col.setRgb(temp,temp,temp);
	}
      else if ((g==NULL)&&(b==NULL)) {
        temp=(int)((double)(r[j][i]%361)*ratio)%256;
	col.setRgb(temp,temp,temp);
	}
      else 
	col.setHsv((r==NULL)?0:(r[j][i]%360),(g==NULL)?0:(g[j][i]%256),(b==NULL)?0:(b[j][i]%256));
      img.setPixel(i,j,col.rgb());
      };

};
printf("QImage to QPixmap ... \n");
*out=img;
printf("done\n");
};
int compare(const u_int *a,const u_int *b)
{
if (*a<*b) return -1;
if (*a>*b) return 1;
return 0;
};


void kClient::convertComplexToInt(int w,int h,double_complex **in,u_int **out,double &ratio)
{
#ifndef SCALE_RIGHT
double maximum=0;
double minimum=10000000;
#endif

int i,j;
#ifdef SHOW_ANGLE
double temp;
#endif
for (j=0;j<h;j++)
   for (i=0;i<w;i++)
      {
#ifdef SHOW_NORM
      out[j][i]=(u_int)sqrt(norm(in[j][i]));
#endif
#ifdef SHOW_ANGLE
//      out[j][i]=((in[j][i].real()==0)?(PI):(atan(in[j][i].imag()/in[j][i].real())+PI/2))*(255.0/PI);
       temp=atan2(in[j][i].imag(),in[j][i].real());
       if (temp<0) temp+=2*PI;
       out[j][i]=(u_int)(temp*255.0/(2*PI));

#endif
#ifndef SCALE_RIGHT
      if (out[j][i]>maximum)
	{
	maximum=out[j][i];
	};
      if (out[j][i]<minimum)
	{
	minimum=out[j][i];
	};
#endif
      };
#ifdef SCALE_RIGHT
if (ratio==-1)
   {
   printf("Guessing median ... ");
   u_int *temp=new u_int[w*h];
   for (j=0;j<h;j++)
      for (i=0;i<w;i++)
         temp[j*w+i]=out[j][i];

   qsort(temp,w*h,sizeof(u_int),&compare);


   ratio=(temp[(w*h)/2]!=0)? (90.0/temp[(w*h)/2]) : (1);
   printf("median : %d , ratio:%g\n",temp[(w*h)/2],ratio);
   delete temp;
   };

#else

ratio=252.0/maximum;
printf("min : %g, max : %g , ratio:%g\n",minimum,maximum,ratio);

#endif

double tmp;
for (j=0;j<h;j++)
   for (i=0;i<w;i++)
      {
//      out[j][i]=(u_int)(out[j][i])%255;
      tmp=(((double)out[j][i])*ratio);
      if (tmp>254) tmp=254;
      out[j][i]=(u_int)tmp;
//      if (out[j][i]>30) printf("%d x %d = %d\n",i,j,out[j][i]); 
      };

};

void kClient::convertComplexToQPixmap(int w,int h,double_complex **in,u_int **tmp,QPixmap *out,int opt)
{
   if (in==NULL) return;
   convertComplexToInt(w,h,in,tmp,fourier_ratio[opt]);

   center_image(w,h,tmp);

   printf("ConvertingIntToPixmap ...\n");
   if (opt==0) convertIntToQPixmap(w,h,tmp,NULL,NULL,out);
    else if (opt==1) convertIntToQPixmap(w,h,NULL,tmp,NULL,out);
    else if (opt==2) convertIntToQPixmap(w,h,NULL,NULL,tmp,out);

};


u_int **kClient::AllocateIntImg(int w,int h,int clear)
{
int i,j;
int wt=is2pow(w);
int ht=is2pow(h);
if ((wt!=w)||(ht!=h))
   {
   printf("Changing size from %dx%d to %dx%d\n",w,h,wt,ht);
   w=wt;
   h=ht;
   clear=1;
   };
u_int **img;
img=new u_int *[h];
for (j=0;j<h;j++)
   img[j]=new u_int[w];

if (clear)
   {
   for (j=0;j<h;j++)
      for (i=0;i<w;i++)
         img[j][i]=0;
   };

return img;
};


double_complex **kClient::AllocateComplexImg(int w,int h,int clear=0)
{
int i,j;
int wt=is2pow(w);
int ht=is2pow(h);
if ((wt!=w)||(ht!=h))
   {
   printf("Changing size from %dx%d to %dx%d\n",w,h,wt,ht);
   w=wt;
   h=ht;
   clear=1;
   };
double_complex **img;
img=new double_complex *[h];
for (j=0;j<h;j++)
   img[j]=new double_complex[w];

if (clear)
   {
   for (j=0;j<h;j++)
      for (i=0;i<w;i++)
         img[j][i]*=0;
   };

return img;
};

void kClient::DeallocateComplexImg(int ,int h,double_complex **img)
{
int j;
for (j=0;j<h;j++)
   delete img[j];
delete img;
};

void kClient::DeallocateIntImg(int ,int h,u_int **img)
{
int j;
for (j=0;j<h;j++)
   delete img[j];
delete img;
};

void kClient::center_image(int w,int h,u_int **img)
{
u_int **tmp=new u_int*[h];
int i,j;
for (i=0;i<h;i++) 
   {
   tmp[i]=new u_int[w];
   for (j=0;j<w;j++)
	{
	tmp[i][j]=img[i][j];
	};
   };

int h2=h/2;
int w2=w/2;

for (j=0;j<h2;j++)
   {
   for (i=0;i<w2;i++)
      {
      img[j][i]=tmp[j+h2][i+w2];
      };
   };
for (j=0;j<h2;j++)
   {
   for (i=w2;i<w;i++)
      {
      img[j][i]=tmp[j+h2][i-w2];
      };
   };
for (j=h2;j<h;j++)
   {
   for (i=0;i<w2;i++)
      {
      img[j][i]=tmp[j-h2][i+w2];
      };
   };
for (j=h2;j<h;j++)
   {
   for (i=w2;i<w;i++)
      {
      img[j][i]=tmp[j-h2][i-w2];
      };
   };


for (i=0;i<h;i++) 
   {
   delete tmp[i];
   };
delete tmp;
};



int kClient::t_Direct(void)
{
if (source_data[0]==NULL) return 1;
if (source_data[1]==NULL) return 1;
if (source_data[2]==NULL) return 1;
printf("Allocating memory ...\n");
int w=imgwidth;
int h=imgheight;

for (int i=0;i<3;i++)
   {
   printf("Pass %d ...\n",i);

   if (fourier_data[i]!=NULL) DeallocateComplexImg(w,h,fourier_data[i]);
   fourier_data[i]=AllocateComplexImg(w,h);
   fourier_u_int_data[i]=AllocateIntImg(w,h);

   printf("Doing Fourier Transform ... \n");
   FT_Direct(is2pow(w),is2pow(h),source_data[i],fourier_data[i]);


   printf("Converting Complex to image ...\n");

   fourier_ratio[i]=-1;
   convertComplexToQPixmap(is2pow(w),is2pow(h),fourier_data[i],fourier_u_int_data[i],fourier_imgs[i],i);


   printf("Done (Direct FT)\n");

   repaint(TRUE);
   };

convertIntToQPixmap(is2pow(w),is2pow(h),fourier_u_int_data[0],fourier_u_int_data[1],fourier_u_int_data[2],fourier_img);

return 0;
};

int kClient::t_Inverse(void)
{
if (fourier_data[0]==NULL) return 1;
if (fourier_data[1]==NULL) return 1;
if (fourier_data[2]==NULL) return 1;
printf("Allocating memory ...\n");
int w=imgwidth;
int h=imgheight;

for (int i=0;i<3;i++)
   {
   printf("Pass %d ...\n",i);

   if (target_data[i]!=NULL) DeallocateIntImg(w,h,target_data[i]);
   target_data[i]=AllocateIntImg(w,h);

   printf("Doing Inverse Fourier Transform ... \n");
   FT_Inverse(is2pow(w),is2pow(h),fourier_data[i],target_data[i]);

   printf("ConvertingIntToPixmap ...\n");
   if (i==0) convertIntToQPixmap(w,h,target_data[i],NULL,NULL,target_imgs[i]);
    else if (i==1) convertIntToQPixmap(w,h,NULL,target_data[i],NULL,target_imgs[i]);
    else if (i==2) convertIntToQPixmap(w,h,NULL,NULL,target_data[i],target_imgs[i]);

   };

printf("ConvertingIntToPixmap ...\n");
convertIntToQPixmap(w,h,target_data[0],target_data[1],target_data[2],target_img);


printf("Done (Inv FT)\n");

repaint(TRUE);

return 0;
};


int kClient::fft_Direct(void)
{
if (source_data[0]==NULL) return 1;
if (source_data[1]==NULL) return 1;
if (source_data[2]==NULL) return 1;
int w=imgwidth;
int h=imgheight;


for (int i=0;i<3;i++)
   {
   printf("Pass %d ...\n",i);

   if (fourier_data[i]!=NULL) DeallocateComplexImg(w,h,fourier_data[i]);
   fourier_data[i]=AllocateComplexImg(w,h);
   fourier_u_int_data[i]=AllocateIntImg(w,h);

   printf("Doing Fourier Transform ... \n");
   FFT2D_real(source_data[i],fourier_data[i],w,h,1);

   printf("Converting Complex to image ...\n");
   fourier_ratio[i]=-1;
 convertComplexToQPixmap(is2pow(w),is2pow(h),fourier_data[i],fourier_u_int_data[i],fourier_imgs[i],i);

   printf("Done (Direct FFT)\n");

   repaint(TRUE);
   };
convertIntToQPixmap(is2pow(w),is2pow(h),fourier_u_int_data[0],fourier_u_int_data[1],fourier_u_int_data[2],fourier_img);
  
repaint(TRUE);

return 0;
};

int kClient::fft_Inverse(void)
{
if (fourier_data[0]==NULL) return 1;
if (fourier_data[1]==NULL) return 1;
if (fourier_data[2]==NULL) return 1;
int w=imgwidth;
int h=imgheight;

for (int i=0;i<3;i++)
   {
   printf("Pass %d ...\n",i);

   if (target_data[i]!=NULL) DeallocateIntImg(w,h,target_data[i]);
   target_data[i]=AllocateIntImg(w,h);

   printf("Doing Inverse Fourier Transform ... \n");
   FFT2D_real(fourier_data[i],target_data[i],w,h,0);

   printf("ConvertingIntToPixmap ...\n");
   if (i==0) convertIntToQPixmap(w,h,target_data[i],NULL,NULL,target_imgs[i]);
    else if (i==1) convertIntToQPixmap(w,h,NULL,target_data[i],NULL,target_imgs[i]);
    else if (i==2) convertIntToQPixmap(w,h,NULL,NULL,target_data[i],target_imgs[i]);
   
   };

printf("ConvertingIntToPixmap ...\n");
convertIntToQPixmap(w,h,target_data[0],target_data[1],target_data[2],target_img);


printf("Done (Inv FT)\n");

repaint(TRUE);

return 0;
};


void kClient::decompose(void)
{
int w=imgwidth;
int h=imgheight;
printf("Decomposing ...\n");
for (int i=0;i<3;i++)
   {
   if (source_data[i]!=NULL) DeallocateIntImg(w,h,source_data[i]);
   source_data[i]=AllocateIntImg(w,h);
   
   convertQPixmapToInt(source_img,source_data[i],i);

   if (i==0) convertIntToQPixmap(w,h,source_data[i],NULL,NULL,source_imgs[i]);
    else if (i==1) convertIntToQPixmap(w,h,NULL,source_data[i],NULL,source_imgs[i]);
    else if (i==2) convertIntToQPixmap(w,h,NULL,NULL,source_data[i],source_imgs[i]);

   };
printf("Done ...\n");

};

void kClient::opt_RGB(void)
{
type_of_decomposition=0;
decompose();
repaint(TRUE);
};

void kClient::opt_HSV(void)
{
type_of_decomposition=1;
decompose();
repaint(TRUE);
};

int kClient::saveFile(int format)
{
saveimageformat=format;
if (saveimage==1) saveimage=0;
  else saveimage=1;
return saveimage;
};

int kClient::Pixmap_at_pto(int &x,int &y,int &col)
// Return values : 
// -1 is none, 0,1,2 is R,G,B component and 3 is the main picture of the column
// In col, it's returned 0 (source), 1 (fourier transform) or 2 (target)
// value returned in x and y is position inside that pixmap
{
int xcorner,ycorner;
int res=3;
int w=is2pow(imgwidth);
int h=is2pow(imgheight);
xcorner=0;
if (y<h)
   {
   ycorner=0;

   if (x<w) {xcorner=0;col=0;}
     else if (x<w+5) res=-1;
     else if (x<w*2+5) {xcorner=w+5;col=1;}
     else if (x<(w+5)*2) res=-1;
     else if (x<(w*3)+10) {xcorner=(w+5)*2;col=2;}
     else res=-1;
   x-=xcorner;
   y-=ycorner;
   return res;
   };

ycorner=h+5;
if (y<ycorner) return -1;
res=-1;
for (res=0;res<3;res++)
{
  if (y<ycorner+h)
    {
    if (x<w) {xcorner=0;col=0;}
      else if (x<w+5) res=-1;
      else if (x<w*2+5) {xcorner=w+5;col=1;}
      else if (x<(w+5)*2) res=-1;
      else if (x<(w*3)+10) {xcorner=(w+5)*2;col=2;}
      else res=-1;
    x-=xcorner;
    y-=ycorner;
    return res;
    };
  ycorner+=h+5;
  if (y<ycorner) return -1;
  }; 
return -1;
};
void kClient::mouseMoveEvent(QMouseEvent *qme)
{
int x=qme->x();
int y=qme->y();
int col;
int p=Pixmap_at_pto(x,y,col);
if ((p==-1)||(p==3))  return;
if (col!=1) return;
if (fourier_data[p]==NULL) return;
int xt=x;
int yt=y;
int w=imgwidth;
int h=imgheight;
int w2=w/2;
int h2=h/2;
if (y<h2)
   y+=h2;
  else
   y-=h2;
if (x<w2)
   x+=w2;
  else
   x-=w2;

double re=fourier_data[p][y][x].real();
double im=fourier_data[p][y][x].imag();
double norma=sqrt(re*re+im*im);
double fi;
if (re==0)
   {
   if (im>0)
	fi=PI/2;
   else
	fi=-PI/2;
   }
  else
   fi=atan2(im,re);
if (norma==0) fi=0;
double figrados=fi*180/PI;
printf("(%d,%d,%d)= %g + %gi ,\t|X| %g ,\tang %g\t=%g\n",xt,yt,p,re,im,norma,fi,figrados);

};

void kClient::mousePressEvent(QMouseEvent *qme)
{
//printf("Click at : %d x %d\n",qme->x(),qme->y());
int x=qme->x();
int y=qme->y();
int col;
int p=Pixmap_at_pto(x,y,col);
int d=(int)sqrt((x-cx)*(x-cx)+(y-cy)*(y-cy));
//printf("Pixmap is : %d . %d and relative pos is : %d x %d\n",p,col,x,y);
//printf("Distance is : %d\n",d);
if (p==-1) return;

if ((qme->button()==LeftButton)&&(saveimage))
   {
   reallySaveImage(col,p);
   if (saveimageformat==0) emit imageSaved_xpm();
      else emit imageSaved_bmp();
   return;
   };


if (col!=1) return;

if (qme->button()==LeftButton) 
   {   
   if (placecenter)
	{
	cx=x;
	cy=y;
	emit centerPlaced();
	return;
	};
   r1=d;
   printf("A\n");
   drawIn(p);
   printf("B\n");
   };

if (qme->button()==RightButton) r2=d;
};

int kClient::placeCenter(void)
{
if (placecenter==1) placecenter=0;
  else placecenter=1;
return placecenter;
};

void kClient::setDrawMode(int mode)
// mode can be:
//  0. Low Pass
//  1. High Pass
//  2. Band Pass
//  3. Band Stop
//  4. Butterworth
{
drawmode=mode;
};

void kClient::drawIn(int p)
{
int w=is2pow(imgwidth);
int h=is2pow(imgheight);
if (p==3)
   {
   switch (drawmode)
      {
      case (0) : DoLowPass(w,h,fourier_data[0]);
                 DoLowPass(w,h,fourier_data[1]);
                 DoLowPass(w,h,fourier_data[2]);
                 break;
      case (1) : DoHighPass(w,h,fourier_data[0]);
                 DoHighPass(w,h,fourier_data[1]);
                 DoHighPass(w,h,fourier_data[2]);
                 break;
      case (2) : DoBandPass(w,h,fourier_data[0]);
                 DoBandPass(w,h,fourier_data[1]);
                 DoBandPass(w,h,fourier_data[2]);
                 break;
      case (3) : DoBandStop(w,h,fourier_data[0]);
                 DoBandStop(w,h,fourier_data[1]);
                 DoBandStop(w,h,fourier_data[2]);
                 break;
      case (4) : DoButterworth(w,h,fourier_data[0]);
                 DoButterworth(w,h,fourier_data[1]);
                 DoButterworth(w,h,fourier_data[2]);
                 break;
      };
      convertComplexToQPixmap(w,h,fourier_data[0],fourier_u_int_data[0],fourier_imgs[0],0);
      convertComplexToQPixmap(w,h,fourier_data[1],fourier_u_int_data[1],fourier_imgs[1],1);
      convertComplexToQPixmap(w,h,fourier_data[2],fourier_u_int_data[2],fourier_imgs[2],2);
      }
     else
      {
      switch (drawmode)
	{
	case (0) : DoLowPass(w,h,fourier_data[p]);break;
	case (1) : DoHighPass(w,h,fourier_data[p]);break;
	case (2) : DoBandPass(w,h,fourier_data[p]);break;
	case (3) : DoBandStop(w,h,fourier_data[p]);break;
	case (4) : DoButterworth(w,h,fourier_data[p]);break;
	};
      convertComplexToQPixmap(w,h,fourier_data[p],fourier_u_int_data[p],fourier_imgs[p],p);
       };	

convertIntToQPixmap(w,h,fourier_u_int_data[0],fourier_u_int_data[1],fourier_u_int_data[2],fourier_img);

repaint(TRUE);
};

void kClient::DoLowPass(int w,int h,double_complex **data)
{
if (data==NULL) return;
int i,j;
int w2=w/2;
int h2=h/2;
int d;
int r1r1=r1*r1;
if (cuad[3]==1)
   {
   printf("1 cuad\n");
   for (i=0;i<h2;i++)
      for (j=w2;j<w;j++)
         {
//         d=(int)sqrt((w-j)*(w-j)+(i*i));
	d=(int)((j-w2-cx)*(j-w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if (d<r1r1) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
if (cuad[4]==1)
   {
   printf("2 cuad\n");
   for (i=0;i<h2;i++)
      for (j=0;j<w2;j++)
         {
//         d=(int)sqrt((j*j)+(i*i));
         d=(int)((j+w2-cx)*(j+w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if (d<r1r1) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
if (cuad[1]==1)
   {
   printf("3 cuad\n");
   for (i=h2;i<h;i++)
      for (j=0;j<w2;j++)
         {
//         d=(int)sqrt((j*j)+(h-i)*(h-i));
         d=(int)((j+w2-cx)*(j+w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if (d<r1r1) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
if (cuad[2]==1)
   {
   printf("4 cuad\n");
   for (i=h2;i<h;i++)
      for (j=w2;j<w;j++)
         {
//         d=(int)sqrt((w-j)*(w-j)+(h-i)*(h-i));
         d=(int)((j-w2-cx)*(j-w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if (d<r1r1) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
};

void kClient::DoHighPass(int w,int h,double_complex **data)
{
if (data==NULL) return;
int i,j;
int w2=w/2;
int h2=h/2;
int d;
int r1r1=r1*r1;
if (cuad[3]==1)
   {
   printf("1 cuad\n");
   for (i=0;i<h2;i++)
      for (j=w2;j<w;j++)
         {
	 d=(int)((j-w2-cx)*(j-w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if (d<r1r1) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
if (cuad[4]==1)
   {
   printf("2 cuad\n");
   for (i=0;i<h2;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)((j+w2-cx)*(j+w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if (d<r1r1) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
if (cuad[1]==1)
   {
   printf("3 cuad\n");
   for (i=h2;i<h;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)((j+w2-cx)*(j+w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if (d<r1r1) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
if (cuad[2]==1)
   {
   printf("4 cuad\n");
   for (i=h2;i<h;i++)
      for (j=w2;j<w;j++)
         {
         d=(int)((j-w2-cx)*(j-w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if (d<r1r1) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
};

void kClient::DoBandPass(int w,int h,double_complex **data)
{
if (data==NULL) return;
int i,j;
int w2=w/2;
int h2=h/2;
int d;
int r1r1=r1*r1;
int r2r2=r2*r2;
if (cuad[3]==1)
   {
   printf("1 cuad\n");
   for (i=0;i<h2;i++)
      for (j=w2;j<w;j++)
         {
	 d=(int)((j-w2-cx)*(j-w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
if (cuad[4]==1)
   {
   printf("2 cuad\n");
   for (i=0;i<h2;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)((j+w2-cx)*(j+w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
if (cuad[1]==1)
   {
   printf("3 cuad\n");
   for (i=h2;i<h;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)((j+w2-cx)*(j+w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
if (cuad[2]==1)
   {
   printf("4 cuad\n");
   for (i=h2;i<h;i++)
      for (j=w2;j<w;j++)
         {
         d=(int)((j-w2-cx)*(j-w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=stop_value;
	   else data[i][j]*=pass_value;
         };
   };
};

void kClient::DoBandStop(int w,int h,double_complex **data)
{
if (data==NULL) return;
int i,j;
int w2=w/2;
int h2=h/2;
int d;
int r1r1=r1*r1;
int r2r2=r2*r2;
if (cuad[3]==1)
   {
   printf("1 cuad\n");
   for (i=0;i<h2;i++)
      for (j=w2;j<w;j++)
         {
	 d=(int)((j-w2-cx)*(j-w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
if (cuad[2]==1)
   {
   printf("2 cuad\n");
   for (i=h2;i<h;i++)
      for (j=w2;j<w;j++)
         {
         d=(int)((j-w2-cx)*(j-w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
if (cuad[1]==1)
   {
   printf("3 cuad\n");
   for (i=h2;i<h;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)((j+w2-cx)*(j+w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
if (cuad[4]==1)
   {
   printf("4 cuad\n");
   for (i=0;i<h2;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)((j+w2-cx)*(j+w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if ((d<r1r1)||(d>r2r2)) data[i][j]*=pass_value;
	   else data[i][j]*=stop_value;
         };
   };
};

void kClient::DoButterworth(int w,int h,double_complex **data)
{
if (data==NULL) return;
int i,j;
int w2=w/2;
int h2=h/2;
int d;
double pv,sv; //passvalue,stopvalue
int rr1,rr2;
if (r1<r2)
   {
   pv=pass_value;
   sv=stop_value;
   rr1=r1;
   rr2=r2;
   }
  else
   {
   pv=stop_value;
   sv=pass_value;
   rr1=r2;
   rr2=r1;
   };
double tempvalue;
double m=(double)(sv-pv)/(double)(rr2-rr1);
if (cuad[3]==1)
   {
   printf("1 cuad\n");
   for (i=0;i<h2;i++)
      for (j=w2;j<w;j++)
         {
	 d=(int)sqrt((j-w2-cx)*(j-w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if (d<rr1) data[i][j]*=pv;
	   else if (d>rr2) data[i][j]*=sv;
	   else 
	     {
	     tempvalue=m*(double)(d-rr1)+(double)pv;
	     data[i][j]*=tempvalue;
	     };
         };
   };
if (cuad[2]==1)
   {
   printf("2 cuad\n");
   for (i=h2;i<h;i++)
      for (j=w2;j<w;j++)
         {
         d=(int)sqrt((j-w2-cx)*(j-w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if (d<rr1) data[i][j]*=pv;
	   else if (d>rr2) data[i][j]*=sv;
	   else 
	     {
	     tempvalue=m*(double)(d-rr1)+(double)pv;
	     data[i][j]*=tempvalue;
	     };
         };
   };
if (cuad[1]==1)
   {
   printf("3 cuad\n");
   for (i=h2;i<h;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)sqrt((j+w2-cx)*(j+w2-cx)+(i-h2-cy)*(i-h2-cy));
	 if (d<rr1) data[i][j]*=pv;
	   else if (d>rr2) data[i][j]*=sv;
	   else 
	     {
	     tempvalue=m*(double)(d-rr1)+(double)pv;
	     data[i][j]*=tempvalue;
	     };
         };
   };
if (cuad[4]==1)
   {
   printf("4 cuad\n");
   for (i=0;i<h2;i++)
      for (j=0;j<w2;j++)
         {
         d=(int)sqrt((j+w2-cx)*(j+w2-cx)+(i+h2-cy)*(i+h2-cy));
	 if (d<rr1) data[i][j]*=pv;
	   else if (d>rr2) data[i][j]*=sv;
	   else 
	     {
	     tempvalue=m*(double)(d-rr1)+(double)pv;
	     data[i][j]*=tempvalue;
	     };
         };
   };
};

int kClient::cuadrant(int i)
{
int r;
if (cuad[i]==1) {cuad[i]=0;r=0;}
   else {cuad[i]=1;r=1;};
return r;
};

void kClient::configvalues(void)
{
ConfigDialog *dlg;

dlg=new ConfigDialog(pass_value,stop_value,NULL,"CfgDialog");
if (dlg->exec() == QDialog::Accepted)
    { 
    pass_value=dlg->passvalue;
    stop_value=dlg->stopvalue;
    };
};

