/**************************************************************************

    kclient.h  - The main client widget of tfourier 
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#ifndef _KCLIENT_H
#define _KCLIENT_H

#include <unistd.h>
#include <sys/types.h>
#include <g++/complex.h>

class KApplication;
class KConfig;
class QLCDNumber;
class QLabel;

class kClient : public QWidget
{
    Q_OBJECT
private:
  int imgwidth;
  int imgheight;

  QPixmap *source_img;
  QPixmap *fourier_img;
  QPixmap *target_img;
 
  u_int **source_data[3];
  double_complex **fourier_data[3];
  u_int **fourier_u_int_data[3];
  double fourier_ratio[3];
  u_int **target_data[3];

  QPixmap *source_imgs[3];
  QPixmap *fourier_imgs[3];
  QPixmap *target_imgs[3];


  int drawmode;
  int cuad[5];

virtual void paintEvent(QPaintEvent *qpe);

u_int **AllocateIntImg(int w,int h,int clear=0);
double_complex **AllocateComplexImg(int w,int h,int clear=0);

void convertQPixmapToInt(QPixmap *qpixmap,u_int **out,int rgb);
void convertIntToQPixmap(int w,int h,u_int **r,u_int **g,u_int **b,QPixmap *out);
void convertComplexToInt(int w,int h,double_complex **in,u_int **out, double &ratio);
void convertComplexToQPixmap(int w,int h,double_complex **in,u_int **tmp,QPixmap *out,int opt);

void DeallocateComplexImg(int w,int h,double_complex **img);
void DeallocateIntImg(int ,int h,u_int **img);
void deallocate_all_memory(void);
void clearImages(void);

void center_image(int w,int h,u_int **img);
int Pixmap_at_pto(int &x,int &y,int &col);

   int type_of_decomposition; // 0 es RGB y 1 es HSV
   double pass_value,stop_value;
   int r1,r2;

   int placecenter;
   int cx,cy;
   int saveimage;
   int saveimageformat;

   void drawIn(int p);
   void DoLowPass(int w,int h,double_complex **data);
   void DoHighPass(int w,int h,double_complex **data);
   void DoBandPass(int w,int h,double_complex **data);
   void DoBandStop(int w,int h,double_complex **data);
   void DoButterworth(int w,int h,double_complex **data);

public:
    kClient(QWidget *parent,const char *name=0);
    ~kClient();

    int openFile(char *filename);
    int saveFile(int format); // 0 is xpm, 1 is bmp
    void reallySaveImage(int col,int p);

    int t_Direct(void);
    int t_Inverse(void);
    int fft_Direct(void);
    int fft_Inverse(void);
    void setDrawMode(int i);
    int cuadrant(int i);
    void configvalues(void);
    int placeCenter(void);

    void decompose(void);

    void opt_RGB(void);
    void opt_HSV(void);

    void setDrawMode(int mode,int degrading);
protected:
   virtual void mousePressEvent(QMouseEvent *qme);
   virtual void mouseMoveEvent(QMouseEvent *qme);
signals:
   void centerPlaced();
   void imageSaved_xpm();
   void imageSaved_bmp();
};

#endif
