/**************************************************************************

    kframe.cpp  - The main widget of kfourier 
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#include "kframe.moc"

#include <qkeycode.h>
#include <stdio.h>
#include <qfiledlg.h>
#include <kapp.h>
#include <qstring.h>
#include <unistd.h>
#include <kmsgbox.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include "kclient.h"
#include <kurl.h>
#include <drag.h>
#include <kfontdialog.h>

kFrame::kFrame(const char *name)
	:KTopLevelWidget(name)
{
	kclient=new kClient(this,"Fourier Transform");
	kclient->show();
	setView(kclient,FALSE);
	connect( kclient, SIGNAL( centerPlaced() ), 
			this, SLOT( draw_placecenter() ) );
	connect( kclient, SIGNAL( imageSaved_xpm() ), 
			this, SLOT( file_Save_xpm() ) );
	connect( kclient, SIGNAL( imageSaved_bmp() ), 
			this, SLOT( file_Save_bmp() ) );

	m_file = new QPopupMenu;
	m_file->setCheckable(TRUE);
	m_file->insertItem( "&Open ...", this, SLOT(file_Open()), CTRL+Key_O );
	m_file->insertItem( "&Save (XPM)...", this, SLOT(file_Save_xpm()) );
        m_file->setId(1,1);
        m_file->setItemChecked(1,FALSE);
	m_file->insertItem( "&Save (BMP)...", this, SLOT(file_Save_bmp()) );
        m_file->setId(2,2);
        m_file->setItemChecked(2,FALSE);
	m_file->insertSeparator();
	m_file->insertItem( "E&xit", qApp, SLOT(quit()), CTRL+Key_Q );
	m_t = new QPopupMenu;
	m_t->insertItem( "Forward FT", this, SLOT(t_Direct()) );
	m_t->insertItem( "Inverse FT", this, SLOT(t_Inverse()) );
	m_t->insertItem( "Forward FFT", this, SLOT(fft_Direct()), Key_Space );
	m_t->insertItem( "Inverse FFT", this, SLOT(fft_Inverse()) ,Key_Backspace);

	m_draw=new QPopupMenu;
	m_draw->setCheckable(TRUE);
	m_draw->insertItem("Low Pass", this,SLOT(draw_LowPass()) );
        m_draw->setId(0,0);
        m_draw->setItemChecked(0,TRUE);
	m_draw->insertItem("High Pass", this,SLOT(draw_HighPass()) );
        m_draw->setId(1,1);
        m_draw->setItemChecked(1,FALSE);
	m_draw->insertItem("Band Pass", this,SLOT(draw_BandPass()) );
        m_draw->setId(2,2);
        m_draw->setItemChecked(2,FALSE);
	m_draw->insertItem("Band Stop", this,SLOT(draw_BandStop()) );
        m_draw->setId(3,3);
        m_draw->setItemChecked(3,FALSE);
	m_draw->insertItem("Linear interpolation",this,SLOT(draw_Butterworth()) );
        m_draw->setId(4,4);
        m_draw->setItemChecked(4,FALSE);
	m_draw->insertSeparator();
	m_cuad = new QPopupMenu;
	m_cuad->setCheckable(TRUE);
	m_cuad->insertItem("1st cuadrant",this,SLOT(cuad_1()) );
        m_cuad->setId(0,0);
        m_cuad->setItemChecked(0,TRUE);
	m_cuad->insertItem("2nd cuadrant",this,SLOT(cuad_2()) );
        m_cuad->setId(1,1);
        m_cuad->setItemChecked(1,TRUE);
	m_cuad->insertItem("3rd cuadrant",this,SLOT(cuad_3()) );
        m_cuad->setId(2,2);
        m_cuad->setItemChecked(2,TRUE);
	m_cuad->insertItem("4th cuadrant",this,SLOT(cuad_4()) );
        m_cuad->setId(3,3);
        m_cuad->setItemChecked(3,TRUE);
	m_draw->insertItem("Cuadrants",m_cuad);
	m_draw->insertSeparator();
	m_draw->insertItem("Change Center",this,SLOT(draw_placecenter()));
        m_draw->setId(8,8);
        m_draw->setItemChecked(8,FALSE);
	m_draw->insertSeparator();
	m_draw->insertItem("Configure values",this,SLOT(draw_configvalues()));

	m_opt = new QPopupMenu;
        m_opt->setCheckable(TRUE);
        m_opt->insertItem( "&RGB", this, SLOT(opt_RGB()) );
        m_opt->setId(0,0);
        m_opt->setItemChecked(0,TRUE);
        m_opt->insertItem( "&HSV", this, SLOT(opt_HSV()) );
        m_opt->setId(1,1);
        m_opt->setItemChecked(1,FALSE);

	m_help = new QPopupMenu;
	m_help->insertItem( "Help", this, SLOT(help_Help()), Key_F1 );
	m_help->insertSeparator();
	m_help->insertItem( "About ...", this, SLOT(help_About()), CTRL+Key_H );

	menu = new KMenuBar(this);
	menu->insertItem("&File",m_file);
	menu->insertItem("&Transform",m_t);
	menu->insertItem("&Filters",m_draw);
	menu->insertItem("&Options",m_opt);
	menu->insertSeparator();
	menu->insertItem("&Help",m_help);
	menu->show();
	setMenu(menu);

	toolbar=new KToolBar(this);
	KIconLoader *loader = (KApplication::getKApplication())->getIconLoader(); 

	toolbar->insertButton(loader->loadIcon("fileopen.xpm"),1,SIGNAL(clicked(int)),this,SLOT(buttonClicked(int)),TRUE,"Open file");
	toolbar->insertButton(loader->loadIcon("forward.xpm"),2,SIGNAL(clicked(int)),this,SLOT(buttonClicked(int)),TRUE,"Fourier Transform (Slow)");
	toolbar->insertButton(loader->loadIcon("back.xpm"),3,SIGNAL(clicked(int)),this,SLOT(buttonClicked(int)),TRUE,"Inverse Fourier Transform (Slow)");
	toolbar->insertButton(loader->loadIcon("finish.xpm"),4,SIGNAL(clicked(int)),this,SLOT(buttonClicked(int)),TRUE,"Forward Fast Fourier Transform");
	toolbar->insertButton(loader->loadIcon("start.xpm"),5,SIGNAL(clicked(int)),this,SLOT(buttonClicked(int)),TRUE,"Inverse Fast Fourier Transform");
	toolbar->insertButton(loader->loadIcon("help.xpm"),6,SIGNAL(clicked(int)),this,SLOT(buttonClicked(int)),TRUE,"Help");

	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
	addToolBar(toolbar);

	KDNDDropZone * dropZone = new KDNDDropZone( this , DndURL);
	connect( dropZone, SIGNAL( dropAction( KDNDDropZone *) ),
		this, SLOT( slotDropEvent( KDNDDropZone *) ) );

        if ((kapp->argc()>1)&& (kapp->argv()[1][0]!='-') )
            {
	    openURL((kapp->argv())[1]);
            };
};

kFrame::~kFrame()
{
delete kclient;
delete m_file;
delete m_t;
delete m_draw;
delete m_cuad;
delete m_opt;
delete m_help;
delete menu;
delete toolbar;
};


void kFrame::buttonClicked(int i)
{
printf("Button : %d\n",i);
switch (i)
    {
    case (1) : file_Open();break;
    case (2) : t_Direct();break;
    case (3) : t_Inverse();break;
    case (4) : fft_Direct();break;
    case (5) : fft_Inverse();break;
    case (6) : help_Help();break;
    };

};

void kFrame::extractFilename(const char *in,char *out)
{
char *p=(char *)in;
char *filename=(char *)in;
while (*p!=0)
    {
    if (*p=='/') filename=p+1;
    p++;
    };
while (*filename!=0)
    {                                                                               *out=*filename;
    out++;
    filename++;
    };
*out=0;
};


void kFrame::file_Open()
{
char name[200];
name[0]=0;
QString filename;
filename=QFileDialog::getOpenFileName(0,"*.*",this,name);
if (!filename.isNull())
        {
        kclient->openFile((char *)(const char *)filename);
        char *fn=new char[strlen(filename)+40];
        extractFilename((const char *)filename,fn);
        char *capt=new char[strlen(fn)+40];
        sprintf(capt,"Fourier Transform- %s",fn);
        topLevelWidget()->setCaption(capt);
        delete capt;
        };
};

void kFrame::file_Save_xpm()
{
int r=kclient->saveFile(0);
m_file->setItemChecked(2,FALSE);
if (r) m_file->setItemChecked(1,TRUE);
  else m_file->setItemChecked(1,FALSE);
};

void kFrame::file_Save_bmp()
{
int r=kclient->saveFile(1);
m_file->setItemChecked(1,FALSE);
if (r) m_file->setItemChecked(2,TRUE);
  else m_file->setItemChecked(2,FALSE);
};

void kFrame::help_Help()
{
KApplication *kappp=KApplication::getKApplication();
kappp->invokeHTMLHelp("kfourier/kfourier.html",NULL);
};

void kFrame::t_Direct()
{
kclient->t_Direct();
};

void kFrame::t_Inverse()
{
kclient->t_Inverse();
};

void kFrame::fft_Direct()
{
kclient->fft_Direct();
};

void kFrame::fft_Inverse()
{
kclient->fft_Inverse();
};

void kFrame::draw_LowPass()
{
kclient->setDrawMode(0);
m_draw->setItemChecked(0,TRUE);
m_draw->setItemChecked(1,FALSE);
m_draw->setItemChecked(2,FALSE);
m_draw->setItemChecked(3,FALSE);
m_draw->setItemChecked(4,FALSE);
}; 

void kFrame::draw_HighPass()
{
kclient->setDrawMode(1);
m_draw->setItemChecked(0,FALSE);
m_draw->setItemChecked(1,TRUE);
m_draw->setItemChecked(2,FALSE);
m_draw->setItemChecked(3,FALSE);
m_draw->setItemChecked(4,FALSE);
};

void kFrame::draw_BandPass()
{
kclient->setDrawMode(2);
m_draw->setItemChecked(0,FALSE);
m_draw->setItemChecked(1,FALSE);
m_draw->setItemChecked(2,TRUE);
m_draw->setItemChecked(3,FALSE);
m_draw->setItemChecked(4,FALSE);
};

void kFrame::draw_BandStop()
{
kclient->setDrawMode(3);
m_draw->setItemChecked(0,FALSE);
m_draw->setItemChecked(1,FALSE);
m_draw->setItemChecked(2,FALSE);
m_draw->setItemChecked(3,TRUE);
m_draw->setItemChecked(4,FALSE);
};

void kFrame::draw_Butterworth()
{
kclient->setDrawMode(4);
m_draw->setItemChecked(0,FALSE);
m_draw->setItemChecked(1,FALSE);
m_draw->setItemChecked(2,FALSE);
m_draw->setItemChecked(3,FALSE);
m_draw->setItemChecked(4,TRUE);
};

void kFrame::draw_placecenter()
{
int r=kclient->placeCenter();
if (r) m_draw->setItemChecked(8,TRUE);
  else m_draw->setItemChecked(8,FALSE);
};

void kFrame::draw_configvalues()
{
kclient->configvalues();
};

void kFrame::cuad_1()
{
int i=kclient->cuadrant(1);
if (i==1) m_cuad->setItemChecked(0,TRUE);
   else m_cuad->setItemChecked(0,FALSE);
};
void kFrame::cuad_2()
{
int i=kclient->cuadrant(2);
if (i==1) m_cuad->setItemChecked(1,TRUE);
   else m_cuad->setItemChecked(1,FALSE);
};

void kFrame::cuad_3()
{
int i=kclient->cuadrant(3);
if (i==1) m_cuad->setItemChecked(2,TRUE);
   else m_cuad->setItemChecked(2,FALSE);
};

void kFrame::cuad_4()
{
int i=kclient->cuadrant(4);
if (i==1) m_cuad->setItemChecked(3,TRUE);
   else m_cuad->setItemChecked(3,FALSE);
};

void kFrame::opt_RGB()
{
kclient->opt_RGB();
m_opt->setItemChecked(0,TRUE);
m_opt->setItemChecked(1,FALSE);
};

void kFrame::opt_HSV()
{
kclient->opt_HSV();
m_opt->setItemChecked(0,FALSE);
m_opt->setItemChecked(1,TRUE);
};


void kFrame::help_About()
{
printf("kfourier 1.1 Copyright (C) 1998 Antonio Larrosa Jimenez. Malaga (Spain)\n");
printf("kfourier comes with ABSOLUTELY NO WARRANTY; for details view file COPYING\n");
printf("This is free software, and you are welcome to redistribute it\n");
printf("under certain conditions\n");
KMsgBox::message( 0, "About kfourier", "Fourier Transform 1.1\n(C) 1998 by Antonio Larrosa Jimenez\n(antlarr@arrakis.es)\nMalaga (Spain)", KMsgBox::INFORMATION, "OK" ); 
};

int kFrame::openURL(char *s)
{
KURL kurldropped(s);
if (kurldropped.isMalformed()) return -1;
if (strcmp(kurldropped.protocol(),"file")!=0) return -1;

char *filename=kurldropped.path();
QString qsfilename(filename);
KURL::decodeURL(qsfilename);
filename=(char *)(const char *)qsfilename;
int r=-1;
if (filename!=NULL)
        {
        r=kclient->openFile(filename);
        }
if (r==-1)
        {
        char *capt=new char[40];
        sprintf(capt,"Fourier Transform");
        topLevelWidget()->setCaption(capt);
        delete capt;
        }
      else
        {
        char *fn=new char[strlen(filename)+40];
        extractFilename(filename,fn);
        char *capt=new char[strlen(fn)+40];
        sprintf(capt,"Fourier Transform - %s",fn);
        topLevelWidget()->setCaption(capt);
        delete capt;
        };
return r;
};


void kFrame::slotDropEvent( KDNDDropZone * _dropZone )
{
  QStrList & list = _dropZone->getURLList();

  char *s=list.first();
  if (openURL(s)==-1)
	{
	return;
	};
};

 
