/**************************************************************************

    kframe.h  - The main widget of tfourier 
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#ifndef _KMIDFRAME_H
#define _KMIDFRAME_H

#include <ktopwidget.h>
#include <kmenubar.h>

class KApplication;
class kClient;
class KToolBar;
class KDNDDropZone;

class kFrame : public KTopLevelWidget
{
    Q_OBJECT
private:
    QPopupMenu *m_file;
    QPopupMenu *m_t;
    QPopupMenu *m_draw;
    QPopupMenu *m_cuad;
    QPopupMenu *m_opt;
    QPopupMenu *m_help;



protected:
    void extractFilename(const char *in,char *out);

public:
    kFrame(const char *name=0);
    ~kFrame();


    int openURL(char *s);

public slots:

    void buttonClicked(int i);
    void file_Open();
    void file_Save_xpm();
    void file_Save_bmp();
    void t_Direct();
    void t_Inverse();
    void fft_Direct();
    void fft_Inverse();
    void draw_LowPass();
    void draw_HighPass();
    void draw_BandPass();
    void draw_BandStop();
    void draw_Butterworth();
    void draw_configvalues();
    void draw_placecenter();
    void cuad_1();
    void cuad_2();
    void cuad_3();
    void cuad_4();

    void opt_RGB();
    void opt_HSV();
    void help_Help();
    void help_About();

    void slotDropEvent( KDNDDropZone * _dropZone );
private:
    KMenuBar *menu;
    kClient *kclient;
    KToolBar *toolbar;
};

#endif
