/**************************************************************************

    tfourier.cc - The functions that do the Fourier transform by its definition
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to antlarr@arrakis.es
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#include "tfourier.h"
#include <stdio.h>
#include <math.h>

int FT_Direct(int w,int h,u_int **in,double_complex **out)
{
/*
               h-1   w-1 
/-             ___   ___
I- [f](n,m) =  \     \            i 2 PI (ni/w+mj/h)
J              /__   /__  f(i,j) e 
               j=0   i=0

  i a  
e            = cos (a) + i sen (a)

*/

double f;
int m,n;
int i,j;
double pi2=2*PI;
double_complex cmplx(0,0);

for (m=0;m<h;m++)
  {
  printf("Row : %d\n",m);
  for (n=0;n<w;n++)
    {
//  Calculate F[f](n,m)
    cmplx*=0;
    for (j=0;j<h;j++)
      {
      for (i=0;i<w;i++)
        {
	f=-pi2*((double)(n*i)/(double)w+(double)(m*j)/(double)h);
        double_complex tmp(cos(f),sin(f));
	cmplx+=in[j][i]*tmp;
        };
      };
    out[m][n]=cmplx;
    };
  };
return 0;
};


int FT_Inverse(int w,int h, double_complex **in,u_int **out)
{
double f;
int m,n;
int i,j;
double pi2=2*PI;
double tempreal;

for (m=0;m<h;m++)
  {
  printf("Row : %d\n",m);
  for (n=0;n<w;n++)
    {
//  Calculate F[f](n,m)
    tempreal=0;
    for (j=0;j<h;j++)
      {
      for (i=0;i<w;i++)
        {
	f=pi2*((double)(n*i)/(double)w+(double)(m*j)/(double)h);
        double_complex tmp(cos(f),sin(f));
	tmp=tmp * in[j][i];
	tempreal+=tmp.real();
        };
      };
    out[m][n]=(u_int)(tempreal/(double)(w*h));
    };
  };

return 0;
};
