
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 
s
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: dnd.c,v 1.2 2000/04/28 20:46:33 dr Exp $ 
*/

 
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "dnd.h"
#include "../lib/image.h"

int            
dnd_set_from_images (GtkSelectionData *selection, GdkAtom type, GList *images) {
  GList *list;
  Image *image;
  int sel_size = 0;
  char *uri, *tmp;

  g_return_val_if_fail (selection && images, 0);

  switch (type) {
  case DND_TARGET_STRING:
  case DND_TARGET_URL:
    
    list = images;
    while (list) {
      image = list->data;
      list = list->next;
      
      sel_size += strlen (image->file_name) + 
	strlen (image->directory) + 8 /* "file:/\r\n" */;
    }

    /* '\0' */
    sel_size ++;

    uri = tmp = g_malloc (sel_size);

    list = images;
    while (list) {
      image = list->data;
      list = list->next;
      
      sprintf (tmp, "file:%s/%s\r\n", image->directory, image->file_name);
      tmp += strlen (tmp);
    }

    gtk_selection_data_set (selection, selection->target, 8, uri, sel_size);

    break;

  default:
    g_assert_not_reached ();
    break;
  }
    
  return 1;
}


GList *        
dnd_get_images (GtkSelectionData *selection, GdkAtom type) {
  GList *images = NULL;
  Image *image;
  char *pos, *tmp, *dir, *name;

  g_return_val_if_fail (selection, NULL);

  if (selection->length < 0 || selection->format != 8)
    return NULL;

  switch (type) {
  case DND_TARGET_STRING:
  case DND_TARGET_URL:
    
    pos = selection->data;
    while (!strncmp (pos, "file:", 5)) {
      dir = pos + 5;
      tmp = strchr (dir, '\r');
      if (tmp) 
	*tmp = 0;
      name = strrchr (dir, '/');
      
      /* no relative path should be here */
      if (name && name [1]) {
	*name = 0;
	
	if (is_readable_image (name + 1, dir)) {
	  image  = image_new (name + 1, dir);
	  images = g_list_append (images, image);
	}

	*name = '/';
      }
      
      if (!tmp)
	break;
      
      *tmp = '\r';
      pos  = tmp + 1;
      
      while (*pos && (*pos == ' ' || *pos == '\n' || *pos == '\r'))
	pos ++;
    }

    break;

  default:
    g_assert_not_reached ();
    break;
  }

  return images;
}
