
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: viewer.h,v 1.5 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _VIEWER_H_
#define _VIEWER_H_

#include <gtk/gtk.h>
#include "../lib/image.h"

typedef struct _Viewer       Viewer;

struct _Viewer {
  GtkWidget    *zimage;
  GtkWidget    *menu;

  ImageSet     *set;
  int          current_image;

  int          diaporama_timeout;
  guint        diaporama_id;

  int          is_fullscreen : 1;
  int          spos [4]; /* saved pos */
};

Viewer *             viewer_new ();
void                 viewer_set_images (Viewer *viewer, ImageSet *set, Image *image);
void                 viewer_set_image (Viewer *viewer, Image *image);

#endif /* _VIEWER_H_ */
