
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: zimage.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _ZIMAGE_H_
#define _ZIMAGE_H_

#include "scrolled.h"
#include "../lib/gpengine.h"
#include "../lib/drawarea.h"

#define ZIMAGE(widget)         ((ZImage *) widget)
#define ZIMAGE_TYPE            (zimage_get_type ())

typedef struct _ZImage         ZImage;
typedef struct _ZImageClass    ZImageClass;

struct _ZImage {
  Scrolled scrolled;
  
  Image       *image;
  Image       *next_image;
  GPEngine    *gpe_load;
 
  DrawArea    *da;

  int       width, height;
  int       x_pad, y_pad;

  int       load_pos;

  int       lx, ly;
  int       mx, my;
};

struct _ZImageClass {
  ScrolledClass parent_class;
};

GtkType                  zimage_get_type ();

GtkWidget *              zimage_new (Image *image);
void                     zimage_set_image (ZImage *zimage, Image *image);
int                      zimage_loaded (ZImage *image);

#endif /* _ZIMAGE_H_ */

