
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: zlist.h,v 1.2 2000/04/28 20:46:34 dr Exp $ 
*/


#ifndef _ZLIST_H_
#define _ZLIST_H_

#include "scrolled.h"

#define ZLIST_TYPE               (zlist_get_type ())
#define ZLIST(widget)            (GTK_CHECK_CAST ((widget), ZLIST_TYPE, ZList))
#define ZLIST_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), ZLIST_TYPE, ZListClass))
#define IS_ZLIST(widget)	 (GTK_CHECK_TYPE ((widget), ZLIST_TYPE))
#define IS_ZLIST_CLASS(klass)	 (GTK_CHECK_CLASS_TYPE ((klass), ZLIST_TYPE))

enum {
  ZLIST_HORIZONTAL        = 1 << 1,
  ZLIST_1                 = 1 << 2,
  ZLIST_USES_DND          = 1 << 3,
  ZLIST_HIGHLIGHTED       = 1 << 4
};

typedef struct _ZList ZList;
typedef struct _ZListClass ZListClass;


struct _ZList {
  Scrolled    scrolled;

  guint       flags;

  gint        cell_width;
  gint        cell_height;

  gint        rows;
  gint        columns;

  GArray      *cells;
  gint        cell_count;

  gint        selection_mode;
  GList       *selection;
  int         focus;
  int         anchor;

  int         cell_x_pad, cell_y_pad;
  int         x_pad, y_pad;

  GtkWidget   *entered_cell;
};

struct _ZListClass {
  ScrolledClass parent_class;

  void          (*clear) (ZList *list);
  void          (*cell_draw) (ZList *list, gpointer cell, GdkRectangle *cell_area, GdkRectangle *area);
  void          (*cell_size_request) (ZList *list, gpointer cell, GtkRequisition *requisition);
  void          (*cell_draw_focus) (ZList *list, gpointer cell, GdkRectangle *cell_area);
  void          (*cell_draw_default) (ZList *list, gpointer cell, GdkRectangle *cell_area);
  void          (*cell_select) (ZList *list, gpointer cell);
  void          (*cell_unselect) (ZList *list, gpointer cell);
};


GtkType       zlist_get_type (void);

void          zlist_construct (ZList *list, int flags);
GtkWidget*    zlist_new (guint flags);
void          zlist_add (ZList *list, gpointer cell);
void          zlist_remove (ZList *list, gpointer cell);
void          zlist_clear (ZList *list);
void          zlist_set_selection_mode (ZList *list, GtkSelectionMode mode);
void          zlist_set_cell_padding (ZList *list, int x_pad, int y_pad);
void          zlist_set_cell_size (ZList *list, gint width, gint height);
void          zlist_set_1 (ZList *list, int one);
gpointer      zlist_cell_from_xy (ZList *list, gint x, gint y);

/* internal */
#define       ZLIST_CELL_FROM_INDEX(list, index)     (g_array_index (ZLIST(list)->cells, gpointer, index))

void          zlist_draw_cell (ZList *list, int index);
int           zlist_update_cell_size (ZList *list, gpointer cell);
int           zlist_cell_index_from_xy (ZList *list, gint x, gint y);

#endif /* _ZLIST_H_ */

  


