
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: codec.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _CODEC_H_
#define _CODEC_H_

#include <stdio.h>
#include "filter.h"
#include "image.h"

#define CODEC_TYPE          (codec_get_type ())
#define CODEC(module)       ((Codec *) module)
#define IS_CODEC(module)    MODULE_CHECK_CAST (MODULE (module), CODEC_TYPE)
#define CODEC_CLASS(module) ((CodecClass *) MODULE_CLASS (module))

typedef struct _Codec       Codec;
typedef struct _CodecClass  CodecClass;
typedef int (*CodecFunc) (Codec *codec);


typedef enum {
  CODEC_CAN_READ_IMAGE,
  CODEC_READ_IMAGE_INFOS,
  CODEC_READ_IMAGE,
  CODEC_WRITE_IMAGE,
  CODEC_OPERATIONS
} CodecOperation;

struct _Codec {
  Filter          filter;

  CodecOperation  operation;

  int             bounding_box_size;
  
  FILE            *file;
};

struct _CodecClass {
  FilterClass     parent_class;
  char            *extensions;

  CodecFunc       operations [CODEC_OPERATIONS];
};

ModuleType        codec_get_type ();

int               codec_can_read_image (char *file_name, char *directory);
ModuleType        codec_find_image_type (char *file_name, char *directory);

Module *          codec_new (CodecOperation operation, int bounding_box_size);
void              codec_set_bounding_box_size (Codec *codec, int size);

/* modules side funcs */

#define           codec_init(codec, w, h, b, sw, sh, sb, stw, sth) \
                    gpengine_pipeline_init (FILTER (codec)->gpe, \
					    w, h, b, sw, sh, sb, stw, sth)
#define           codec_add_tile(codec, tile) \
                    gpengine_pipeline_process_tile (FILTER (codec)->gpe, tile)

#define           codec_get_buffer(codec)  FILTER (codec)->buffer
#define           codec_get_image(codec)   FILTER (codec)->image
#define           codec_get_cache(codec)   gpengine_get_cache (FILTER (codec)->gpe)

#endif /* _CODEC_H_ */



