
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: draw.h,v 1.4 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _DRAW_H_
#define _DRAW_H_

#include <gdk/gdk.h>
#include "filter.h"

#define DRAW_TYPE               draw_get_type ()
#define DRAW(module)            ((Draw *) module)
#define DRAW_CLASS(module)      ((DrawClass *) MODULE_CLASS(module))

typedef struct _Draw            Draw;
typedef struct _DrawClass       DrawClass;


struct _Draw {
  Filter       filter;

  GdkDrawable  *drawable;
  GdkGC        *gc;

  ImagePixmap  *ipix;
  int          build_pixmap;
  int          pixmap_depth;
  int          out_x, out_y;

};

struct _DrawClass {
  FilterClass  parent_class;
};

ModuleType                 draw_get_type ();
Module *                   draw_new (GdkDrawable *drawable, GdkGC *gc, int build_pixmap, int pixmap_depth);
void                       draw_set_output_pos (Draw *draw, int out_x, int out_y);

#endif /* _DRAW_H_ */




