
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: drawarea.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _DRAW_AREA_H_
#define _DRAW_AREA_H_

#include "filter.h"

#include "draw.h"
#include "scale.h"

#define DRAW_AREA_ZOOM_IN(zoom)            ((zoom) == -1 ? 2 : (zoom) + 1)
#define DRAW_AREA_ZOOM_OUT(zoom)           ((zoom) == 1  ? -2 : (zoom) - 1)

#define DRAW_AREA_APPLY_ZOOM(da, i)      \
            ((da)->zoom < 0 ? (double) (i) / -(da)->zoom : (double)  (da)->zoom * (i))
#define DRAW_AREA_APPLY_IZOOM(da, i)     \
            ((da)->zoom > 0 ? (double) (i) / (da)->zoom  : (double) -(da)->zoom * (i))

typedef struct _DrawArea       DrawArea;
typedef struct _DrawAreaClass  DrawAreaClass;


struct _DrawArea {
  Filter filter;

  Image  *image;
  ImageCache *cache;

  int    zoom;
  Scale  *scale;
  Draw   *draw;
  
  int    initialized;
};

struct _DrawAreaClass {
  FilterClass filter_class;
};


ModuleType                 draw_area_get_type ();


Module *                   draw_area_new (GdkDrawable *drawable, 
					  GdkGC *gc,
					  GdkColor *background);
int                        draw_area_set_zoom (DrawArea *da, int zoom);
int                        draw_area_zoom_in (DrawArea *da);
int                        draw_area_zoom_out (DrawArea *da);
int                        draw_area_set_image (DrawArea *da, Image *image);
void                       draw_area_draw (DrawArea *da, 
					   int x, int y,
					   GdkRectangle *area);


#endif /* _DRAW_AREA_H */
