
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: module.c,v 1.10 2000/04/28 20:46:34 dr Exp $ 
*/


#include <stdio.h>
#include "module.h"

#define MAX_PATH_SIZE  1024

static void                module_init (Module *module);
static void                module_class_init (ModuleClass *class);
static void                module_real_free (Module *module);
static ParamI *            find_parami (Module *module, Param *param);

ModuleType
module_get_type () {
  static ModuleType     type = 0;

  if (!type) {
    static ModuleTypeInfo module_type_info = {
      "Module",
      NULL,
      NULL,
      sizeof (Module),
      sizeof (ModuleClass),
      module_init,
      module_class_init,
      /* reserved 1 */ NULL,
      /* reserved 2 */ NULL
    };

    type = module_type_unique (0, &module_type_info);
  }

  return type;
}

static void
module_class_init (ModuleClass *class) {

  class->free             = module_real_free;
}

static void
module_init (Module *module) {

}

void
module_free (Module *module) {
  module_type_free (module);
}

void
module_real_free (Module *module) {
  GList *list;

  list = module->params;
  while (list) {
    parami_free ((ParamI *) list->data);
    list = list->next;
  }

  if (module->params) 
    g_list_free (module->params);
}

void
module_class_add_param (ModuleClass *klass, Param *param) {
  g_return_if_fail (klass && param);

  param_node_add_param (klass->params_node, param);
}

ParamValue *
module_get_param_value (Module *module, char *name, 
			ParamType type) {
  Param  *param;
  ParamI *parami;

  g_return_val_if_fail (module && name, NULL);

  param  = param_find (MODULE_CLASS (module)->params_node, name);
  if (!param)
    return NULL;

  parami = find_parami (module, param);

  return parami ? 
    parami_get_value (parami, type) :
    param_get_value (param, type);
}

void
module_set_param_value (Module *module, char *name,
			ParamType type, ParamValue value) {
  Param *param;
  ParamI *parami;

  param  = param_find (MODULE_CLASS (module)->params_node, name);
  g_return_if_fail (param);
  
  parami = find_parami (module, param);
  
  if (parami) {
    parami_set_value (parami, type, value);
  } else {
    parami = parami_new (param, type, value);
    module->params = g_list_append (module->params, parami);
  }
}

void
module_clear_param_value (Module *module, char *name) {
  Param  *param;
  ParamI *parami;

  g_return_if_fail (module && name);
  
  param  = param_find (MODULE_CLASS (module)->params_node, name);
  g_return_if_fail (param);

  parami = find_parami (module, param);
  if (parami) {
    module->params = g_list_remove (module->params, parami);
    parami_free (parami);
  }
}

static ParamI *
find_parami (Module *module, Param *param) {
  GList *list;

  list = module->params;
  while (list) {
    if (((ParamI *) list->data)->param == param)
      return (ParamI *) list->data;

    list = list->next;
  }

  return NULL;
}

void
module_error (Module *module, char *format, ...) {
  va_list ap;
  
  //fprintf (stderr, "*** Module %s produced the following error:\n", module->class->name);

  va_start (ap, format);
  vfprintf (stderr, format, ap);
  va_end (ap);
  
  fprintf (stderr, "\n");
}




