
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: module.h,v 1.9 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _MODULE_H_
#define _MODULE_H_

/*
  Using GtkObjects would surely be better,
  but might require additional synchronisation ?
*/

#include <gtk/gtkwidget.h>
#include "param.h"

#define MODULE(module)                   ((Module *) module)
#define MODULE_CLASS(module)             ((ModuleClass *) MODULE (module)->class)
#define MODULE_PARENT_CLASS(module)      (MODULE_CLASS(module)->parent_class)
#define MODULE_TYPE(module)              (MODULE_CLASS(module)->type)
#define MODULE_CHECK_CAST(module, type)  module_type_is_a (MODULE(module), type)

typedef struct _Module            Module;
typedef struct _ModuleClass       ModuleClass;

#include "module_type.h"

struct _Module {
  GList         *params;

  ModuleClass   *class;
};

struct _ModuleClass {  
  ModuleType   type;
  ModuleClass  *parent_class; 

  GNode        *params_node;

  void         (*free)              (Module *module);
};
 
ModuleType   module_get_type                 ();

void          module_free                     (Module *module); 

void          module_error                    (Module *module, char *format, ...);

void          module_set_param_value          (Module *module, char *name, 
					       ParamType type, ParamValue value);
ParamValue *  module_get_param_value          (Module *module, char *name, 
					       ParamType type);
void          module_clear_param_value        (Module *module, char *name);

/* internal */

void         module_class_add_param          (ModuleClass *klass, Param *param);
#define      module_add_param(module, param) module_class_add_param (MODULE_CLASS (module), param)

#endif












