
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: module_type.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _MODULE_TYPE_H_
#define _MODULE_TYPE_H_

#include <glib.h>

typedef guint   ModuleType;
typedef struct _ModuleTypeInfo       ModuleTypeInfo;

#include "module.h"

struct _ModuleTypeInfo {
  char         *name;
  char         *description;
  char         *authors;
  guint        module_size;
  guint        class_size;
  void         (*module_init)             (Module *module);
  void         (*module_class_init)       (ModuleClass *class);
  gpointer     reserved1;
  gpointer     reserved2;
};

guint              module_type_unique (ModuleType parent_type, ModuleTypeInfo *info);
Module *           module_type_new (ModuleType type);
void               module_type_free (Module *module);

int                module_type_is_a (Module *module, ModuleType type);

#endif /* _MODULE_TYPE_H_ */



