
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: png_module.c,v 1.4 2000/04/28 20:46:35 dr Exp $ 
*/


#include <png.h>
#include "png_module.h"

static void                   png__class_init (ModuleClass *class);
static void                   png__init (Module *module);
static int                    png__can_read (Codec *codec);
static int                    png__read_image_infos (Codec *codec);
static int                    png__read_image (Codec *codec);
static int                    png__write_image (Codec *codec);

ModuleType 
png_get_type () {
  static ModuleType type = 0;

  if (!type) {
    static ModuleTypeInfo png_info = {
      "Png",
      NULL,
      NULL,
      sizeof (Png),
      sizeof (PngClass),
      png__init,
      png__class_init,
      /* reserved 1 */ NULL,
      /* reserved 2 */ NULL
    };

    type = module_type_unique (codec_get_type (), &png_info);
  }

  return type;
}

static void
png__class_init (ModuleClass *class) {
  static char *extensions = ".png.";
  CodecClass  *codec_class;
  CodecFunc   *operations;
  
  codec_class = (CodecClass *) class;

  codec_class->extensions        = extensions;

  operations = codec_class->operations;

  operations [CODEC_CAN_READ_IMAGE]    = png__can_read;
  operations [CODEC_READ_IMAGE_INFOS]  = png__read_image_infos;
  operations [CODEC_READ_IMAGE]        = png__read_image;
  operations [CODEC_WRITE_IMAGE]       = png__write_image;
}

static void
png__init (Module *module) {

}

static int                    
png__can_read (Codec *codec) {

  return 0;
}

static int                    
png__read_image_infos (Codec *codec) {

  return 0;
}

static int                    
png__read_image (Codec *codec) {
  png_structp png;
  png_infop info;
  png_uint_32 width, height;
  FilterTile *buffer;
  int depth, bit_depth, color_type, y;

  png = png_create_read_struct (PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
  if (!png) return 0;

  info = png_create_info_struct (png);
  if (!info) {
    png_destroy_read_struct (&png, NULL, NULL);
    return 0;
  }

  if (setjmp (png->jmpbuf)) {
    png_destroy_read_struct (&png, &info, NULL);
    return 0;
  }

  png_init_io (png, codec->file);

  png_read_info (png, info);

  color_type = png_get_color_type (png, info);
  bit_depth = png_get_bit_depth (png, info);
  width = png_get_image_width (png, info);
  height = png_get_image_height (png, info);

  if (bit_depth == 16)
    png_set_strip_16 (png);
  else if (bit_depth < 8)
    png_set_packing (png);

  if (color_type == PNG_COLOR_TYPE_PALETTE)
    png_set_expand (png);

  if (png_get_valid (png, info, PNG_INFO_tRNS))
    png_set_expand (png);

  png_read_update_info (png, info);
  color_type = png_get_color_type (png, info);
  
  switch (color_type) {
  case PNG_COLOR_TYPE_GRAY:
    depth = 1;
    break;
  case PNG_COLOR_TYPE_GRAY_ALPHA:
    depth = 2;
    break;
  case PNG_COLOR_TYPE_RGB:
    depth = 3;
    break;
  case PNG_COLOR_TYPE_RGB_ALPHA:
    depth = 4;
    break;
  default:
    module_error (MODULE(codec), "unsuported color type (%d)", color_type);
    png_destroy_read_struct (&png, &info, NULL);
    return 0;
  }

  codec_init (codec, 
	      width, height, depth,
	      width, height, depth,
	      width, 1);
  buffer = codec_get_buffer (codec);

  for (y = 0; y < height; y++) {
    png_read_rows (png, &buffer->data, NULL, 1);
    if (!codec_add_tile (codec, buffer)) {
      png_destroy_read_struct (&png, &info, NULL);
      return 0;
    }
  }

  png_read_end (png, info);
  png_destroy_read_struct (&png, &info, NULL);

  return 1;
}

static int                    
png__write_image (Codec *codec) {

  return 0;
}

      


