/*
**
** ScrollbarP.h
**
** Copyright (C) 1994-1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#ifndef _ScrollbarP_h
#define _ScrollbarP_h

#ifdef VMS
#   include <XAW_DIRECTORY/Scrollbar.h>
#   include <XAW_DIRECTORY/ThreeDP.h>
#else
#   include "Scrollbar.h"
#   include <X11/Xaw3d/ThreeDP.h>
#endif

typedef struct {
     /* public */
    Pixel		foreground;		/* thumb foreground color */
    XtOrientation	orientation;		/* horizontal or vertical */
    XtCallbackList	scrollProc;		/* proportional scroll */
    XtCallbackList	thumbProc;		/* jump (to position) scroll */
    XtCallbackList	jumpProc;		/* same as thumbProc but pass data by ref */
    Pixmap		thumb;			/* thumb color */
    float		top;			/* relative position of top of thumb  */
    float		shown;			/* What percent is shown in the win */
    Dimension		length;			/* either height or width */
    Dimension		thickness;		/* either width or height */
    Dimension		min_thumb;		/* minium size for the thumb. */
    Dimension		thumb_top_indent;
    Dimension		thumb_side_indent;
    Boolean		show_arrows;		/* if the arrows are shown */
    Dimension		arrow_top_indent; 	/* arrow indentation top <-> border */
    Dimension		arrow_side_indent;    	/* arrow indentation side <-> border */
    int			interval;		/* time base for autoscroll (milliseconds) */
    int			delay;			/* time base for autoscroll (milliseconds) */
    Boolean		use_dynamic;		/* if the dynamic arrow scrolling is used */
    /* private */
    Dimension		dynamic;		/* dynamic autoscroll time interval */ 
    XtIntervalId	timer_id;		/* autorepeat timer; remove on destruction */
    char		scroll_mode;		/* 0:none 1:up/back 2:track 3:down/forward */
    GC			gc;			/* a (shared) gc */
    Dimension		topLoc;			/* position of top of thumb */
    Dimension		shownLength;		/* shown length of thumb    */
    Dimension		shadow_base;            /* the shadow width used to derive arrow_shadow, etc.    */
    int			arrow_width;
    int			arrow_height;
    int			arrow_top_to_border;
    int			arrow_to_border;
    int			arrow_shadow;
    int			thumb_shadow;
    int			thumb_to_arrow;
    int			thumb_to_border;
} ScrollbarPart;

typedef struct _ScrollbarRec {
    CorePart		core;
    SimplePart		simple;
    ThreeDPart		threeD;
    ScrollbarPart	scrollbar;
} ScrollbarRec;

typedef struct {int empty;} ScrollbarClassPart;

typedef struct _ScrollbarClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    ThreeDClassPart	threeD_class;
    ScrollbarClassPart	scrollbar_class;
} ScrollbarClassRec;

#ifdef VMS  /*pragma ###jp### 06/18/95 */
#   include <XAW_DIRECTORY/Xaw3D_VMS_PRAGMA_S.H>
#else
#   define _EXTERN_ extern
#endif 

_EXTERN_ ScrollbarClassRec scrollbarClassRec;

#undef _EXTERN_
#ifdef VMS  /*pragma ###jp### 06/18/95 */
#   include <XAW_DIRECTORY/Xaw3D_VMS_PRAGMA_E.H>
#endif

#endif /* _ScrollbarP_h */
