# @(#)$Mu: make/sys.dynix.mk,v 1.39 $
##
## sys.dynix.mk
##	system dependent makefile for dynix/ptx 4.0
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

##
## Dynix/ptx 4.0/cc
##
## expect warnings like "warning: syntax error: "&..." invalid",
## stdarg.h has bugs on dynix.
##
sysname    = Dynix/ptx 4.0 (cc)
sys        = SY_DYNIX
mk-putenv  = yes
mk-xpm     = yes
mk-libhelp = no
mk-editres = yes

cc      = cc
perl    = /usr/local/bin/perl
opt     = -O2
incl    = -I. -I/usr/local/include
warn    = -Xc -v -Wc,-pw
defs    = -D$(sys) -D_XOPEN_SOURCE
ldflags = -s $(opt) -L/usr/local/lib
xlibs   = -lXm -lXpm -lXmu -lXt -lX11 -lm -lsocket
hlibs   = -lhlpclient
ar      = ar
arflags = r
m4      = $(top)/tools/p4 -P

dep    = makedepend
dflags = -f-

mkdir    = mkdirhier
install  = $(top)/tools/mutstall
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
libdir   = /usr/local/lib/$(projname)
libflags = $(manflags)
addir    = $(libdir)
adflags  = $(libflags)
