# @(#)$Mu: make/sys.freebsd3.mk,v 1.7 $
##
## sys.freebsd3.mk
##	System dependent makefile for FreeBSD 3.0/gcc.
##
## Copyright (C) 1997  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

sysname    = FreeBSD 3.0
sys        = SY_FREEBSD
mk-putenv  = no
mk-xpm     = yes
mk-libhelp = no
mk-editres = yes

cc      = gcc 
perl    = /usr/bin/perl
warn    = -ansi -pedantic -W -Wall -Werror -Wmissing-prototypes
defs    = -D$(sys)
opt     = -O2
incl    = -I. -I/usr/local/include -I/usr/X11R6/include -I/usr/X11/include
ldflags = -s -L/usr/local/lib -L/usr/X11R6/lib -L/usr/X11/lib $(opt)
xlibs   = -lXm -lXpm -lXmu -lXt -lXext -lX11 -lm -lcompat
hlibs   = -lhlpclient
ar      = ar
arflags = -r
m4      = m4 -P
ranlib  = ranlib

dep    = gcc
dflags = -M

mkdir    = mkdirhier
install  = install -c
bindir   = /usr/local/bin
binflags = -o root -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o root -g bin -m 644
libdir   = /usr/local/lib/$(projname)
libflags = $(manflags)
addir    = $(libdir)
adflags  = $(libflags)
