# @(#)$Mu: make/sys.solaris-x86-gcc.mk,v 1.9 $
##
## sys.solaris-x86-gcc.mk
##	system dependent makefile for Solaris 2.6/gcc Intel
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

##
## Solaris 2.6/gcc Intel
##
sysname    = Solaris 2.6 (gcc/Intel)
sys        = SY_SUN
mk-putenv  = no
mk-xpm     = yes
mk-libhelp = no
mk-editres = yes

cc       = gcc
perl     = /usr/local/bin/perl
purify   = purify -chain-length="10"
quantify = quantify
cover    = purecov
warn     = -ansi -pedantic -W -Wall -Werror -Wmissing-prototypes
defs     = -D$(sys) -D_POSIX_SOURCE -D_XOPEN_SOURCE -Di386 -DSVR4 -Dsun
opt      = -O2
incl     = -I. -I/usr/local/include -I/usr/dt/include -I/usr/openwin/include
ldflags  = -s $(opt) -L/usr/local/lib -L/usr/dt/lib -L/usr/openwin/lib
xlibs    = -lXm -lXpm -lXmu -lXt -lXext -lX11 -lsocket -lnsl -lm
hlibs    = -lhlpclient
ar       = ar
arflags  = r
m4       = $(top)/tools/p4 -P

defs_socket = -DBUSTED_SYS_TYPES

dep    = gcc
dflags = -M

mkdir    = mkdirhier
install  = /usr/ucb/install -c
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
libdir   = /usr/local/lib/$(projname)
libflags = $(manflags)
addir    = $(libdir)
adflags  = $(libflags)
