/*
 * mark.c
 *	Page marking callbacks for mgv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#include <wlib/rcs.h>
MU_ID("$Mu: mgv/mark.c,v 1.21 $")

#include <assert.h>
#include <ctype.h>
#include <Xm/List.h>

#include <wlib/wlib.h>
#include <wlib/typesanity.h>
#include <mine/mgv.h>
#include <mine/mark.h>
#include <mine/util.h>

/*
 * mark->mark
 */
void
mgv_mark_mark(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	mgv_mark(m, m->page, !m->dsc->pages[m->page].mark, TRUE);
}

/*
 * mark->mark all, mark->unmark all
 */
void
mgv_mark_markall(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	int	i, max;
	int	mark;
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	max = (m->dsc == NULL) ? 0 : m->dsc->n_pages;
	mark = *XtName(w) == 'm';
	for(i = 0; i < max; ++i)
		mgv_mark(m, i, mark, FALSE);
	mgv_list_update(m, -1);
}

/*
 * mark->even, mark->odd
 */
void
mgv_mark_evenodd(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	int	i, start, max;
	USEUP(call);
	assert(MgvOK(m));

	/*
	 * Remember:  page numbers start at one but the indices
	 * start at zero.
	 */
	start = (*XtName(w) == 'o') ? 0 : 1;
	max   = (m->dsc == NULL) ? 0 : m->dsc->n_pages;
	for(i = start; i < max; i += 2)
		mgv_mark(m, i, TRUE, FALSE);
	mgv_list_update(m, -1);
}

/*
 * mark->invert
 */
void
mgv_mark_invert(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	int	i, n;
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	XtVaGetValues(m->list, XmNitemCount, &n, NULL);
	for(i = 0; i < n; ++i)
		mgv_mark(m, i, !m->dsc->pages[i].mark, FALSE);
	mgv_list_update(m, -1);
}

/*
 * page marking action
 */
void
mgv_action_mark(Widget w, XEvent *ev, String *argv, Cardinal *argc)
{
	int		item, n_items;
	MGV		*m;
	Widget		mainwin;
	USEUP(argv); USEUP(argc);

	mainwin = wl_findup(w, "mainWindow");
	assert(mainwin != NULL);
	XtVaGetValues(mainwin, XmNuserData, &m, NULL);
	assert(MgvOK(m));

	/*
	 * sanity
	 */
	if(w != m->list
	|| ev->type      != ButtonPress
	|| m->dsc        == NULL
	|| m->dsc->pages == NULL) {
		XBell(XtDisplay(mainwin), 100);
		return;
	}

	XtVaGetValues(w, XmNitemCount, &n_items, NULL);
	if((item = XmListYToPos(w, ((XButtonEvent *)ev)->y)) > n_items) {
		XBell(XtDisplay(mainwin), 100);
		return;
	}
	mgv_mark(m, item - 1, !m->dsc->pages[item - 1].mark, TRUE);
}
