/*
 * mgv.h
 *	Main header for mgv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#ifndef	MGV_MGV_H
#define	MGV_MGV_H
MU_HID(mgv_h, "$Mu: mgv/mine/mgv.h,v 1.137 $")

#include <stdio.h>
#include <sys/types.h>
#include <X11/Intrinsic.h>

#include <mine/Ghostview.h>
#include <mine/dsc.h>

/*
 * Upper and lower bounds on the magstep menu radio buttons.
 * These should match the magstep menu.
 */
#define	MGV_MAGMAX	+5
#define	MGV_MAGMIN	-5

/*
 * A zoom window.
 */
typedef struct mgv_zoom_s *MGV_ZOOM;

/*
 * The page stack (we have to declare this here to avoid
 * #include loop badness).
 */
typedef struct PGSTACK_s *PGSTACK;

/*
 * misc flags for MGV.bits
 */
#define	MgvALIASEPS	(1 << 0)
#define	MgvFORCEDORIENT	(1 << 1)
#define	MgvHIDELOG	(1 << 2)
#define	MgvMENUDOWN	(1 << 3)
#define	MgvZOOMDRAWN	(1 << 4)
#define	MgvMAGICSCROLL	(1 << 5)
#define	MgvSMOOTH	(1 << 6)
#define	MgvSMARTSIZE	(1 << 7)

#define	MgvRESETSCROLL_H	(1 << 8)
#define	MgvRESETSCROLL_V	(1 << 9)
#define	MgvRESETSCROLL		(MgvRESETSCROLL_H | MgvRESETSCROLL_V)

/*
 * This structure defines one instance of mgv.  All of the functions
 * exist soley to support and maintain instances of this struct.
 *
 * Pointers to these things get tossed around as void * a lot
 * so we'll go for a little paranoia and attach some magic numbers.
 *
 * Unless otherwise noted, all pointers in these structs are allocated.
 */
#define	MgvMAGIC1	0x4d475600L	/* 'M' 'G' 'V' */
#define	MgvMAGIC2	0x0056474dL	/* 'V' 'G' 'M' */
#define	MgvTZOOM	(1 << 1)
#define	MgvTFULL	(MgvTZOOM | (1 << 2))
typedef struct MGV_s {
	long		secret_handshake1;
	int		type;
	int		inst_num;

	struct MGV_s	*parent;

	/*
	 * my name
	 */
	String	name;

	/*
	 * some important widgets
	 */
	Widget		main;		/* main form			*/
	Widget		sw;		/* the scrolled window		*/
	Widget		ghost;		/* the Ghostview widget		*/
	Widget		list;		/* the page list		*/
	Widget		tracker;	/* position label		*/
	Widget		orienttog;	/* current orientation toggle	*/
	Widget		mediatog;	/* current media toggle		*/
	Widget		popup;		/* the popup menu		*/
	Widget		clip;		/* clip window to sw		*/
	Widget		magsteptog;	/* current magstep toggle	*/

	/*
	 * dialog cache
	 */
	Widget		fs_open;	/* file selector dialog (open)	*/
	Widget		fs_save;	/* file selector dialog (save)	*/
	Widget		save_query;	/* exists? overwrite		*/
	Widget		about;		/* about dialog			*/
	Widget		printdlg;	/* print dialog			*/
	Widget		print_msg;	/* print status message box	*/
	Widget		log;		/* the log			*/
	Widget		magstep;	/* set magstep dialog		*/
	Widget		docinfo;	/* document info dialog		*/

	/*
	 * the open file
	 */
	FILE		*fp;		/* the PostScript file		*/
	char		*realfile;	/* the file name we really used	*/
	char		*file;		/* the user requested file name	*/
	char		*title, *date;	/* neither is malloced		*/
	DSC		*dsc;		/* structre information		*/
	int		page;		/* current page number		*/

	/*
	 * misc
	 */
	GvPageOrientation orient;
	int		magnify;
	int		default_xdpi, default_ydpi;
	int		default_media;
	int		n_marked;
	int		sens;		/* sensitivity bitmap		*/
	char		*savefile;	/* name we're attempting to save to */
	long		bits;
	String		printcmd;
	Pixmap		icon, mask;

	Boolean		defalias, labels, pgnums;

	/*
	 * Magic/smooth scrolling support.
	 */
	int		last_magic;
	int		magic_resistance;
	int		smoothness;
	float		scrollfactor;

	/*
	 * Page number stack.
	 */
	PGSTACK		pgstack;

	/*
	 * Window sizing function.  This function handles the automatic
	 * size/width/height stuff.  This should never be NULL.
	 */
	void	(*autosizer)(struct MGV_s *);

	/*
	 * The root_width and root_height values are adjusted to compenstate
	 * for the wmWidth and wmHeight resources; life would be a little
	 * more pleasant if we could ask someone how large the window
	 * decorations are but the required incantations (I have tried
	 * many) are beyond me at the moment.  The root_width and root_height
	 * values are only used to limit the size of the window during
	 * auto-sizing and, technically, that is your window manager's job
	 * so I'm not going to worry too much about it.
	 */
	int	root_width, root_height;

	/*
	 * zoom window
	 */
	int		zoom_startx, zoom_starty;
	int		zoom_curx,   zoom_cury;
	int		zoom_linewidth;
	GC		reticule_gc;
	Widget		zoom_menu;
	MGV_ZOOM	zoomers;
	int		n_zooms;

	long		secret_handshake2;
} MGV;

#define	MgvISZOOM(m)	((m) != NULL && ((m)->type & ~MgvTZOOM) == 0)

#define	MgvOK(m)	mgv_ok((m), FALSE)
#define	MgvZOK(m)	mgv_ok((m), TRUE)

/*
 * this is used as the media parameter to mgv_media() if you
 * want to use the bounding box in the ps file
 */
#define	MgvUSEBBOX	-1

CDECLS_BEGIN
extern	MGV	*mgv_alloc(char *file);
extern	void	mgv_close(MGV *m, int preserve_orient, int reset_kludge);
extern	MGV	*mgv_create(Widget top, char *file);
extern	MGV	*mgv_free(MGV *m);
extern	int	mgv_label(MGV *m, int page, char *buf);
extern	int	mgv_magnify(MGV *m, int mag);
extern	void	mgv_mark(MGV *m, int page, int mark, int update);
extern	void	mgv_media(MGV *m, int media);
extern	int	mgv_ok(MGV *m, int zoom);
extern	int	mgv_open(MGV *m, char *file);
extern	int	mgv_open_fp(MGV *m, FILE *fp);
extern	void	mgv_orient(MGV *m, GvPageOrientation orient, int force);
extern	void	mgv_refresh(MGV *m);
extern	void	mgv_show(MGV *m, int page);
extern	MGV	*mgv_top(MGV *m);
extern	int	mgv_write(MGV *m, FILE *out, int marked);
extern	MGV	*mgv_zdup(MGV *m);
CDECLS_END

#endif
