/*
 * util.c
 *	Miscellaneous utility functions for mgv.
 *
 * Copyright (C) 1998 Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.va)
 */
#include <wlib/rcs.h>
MU_ID("$Mu: mgv/util.c,v 1.3 $")

#include <Xm/Xm.h>
#include <Xm/List.h>

#include <mine/mgv.h>
#include <mine/util.h>
#include <mine/sens.h>

/*
 * Update the page list.
 * If 'page' is non-positive, then the whole list will be updated.
 */
void
mgv_list_update(MGV *m, int page)
{
	char buf[128];
	char *font;
	int  i;
	XmString *strings;

	if(m->dsc == NULL
	|| m->dsc->n_pages <= 0)
		return;

	if(page > 0) {
		XmString x;
		font = m->dsc->pages[page - 1].mark
			? "MARKED"
			: "UNMARKED";
		mgv_label(m, page - 1, buf);
		x = XmStringCreateLtoR(buf, font);
		XmListReplaceItemsPos(m->list, &x, 1, page);
		XmStringFree(x);
		mgv_sens(m->main, m->sens);
		if(page == m->page)
			XmListSelectPos(m->list, page, False);
		return;
	}

	strings = (XmString *)XtCalloc(m->dsc->n_pages, sizeof(XmString));
	for(i = 0; i < m->dsc->n_pages; ++i) {
		font = m->dsc->pages[i].mark
			? "MARKED"
			: "UNMARKED";
		mgv_label(m, i, buf);
		strings[i] = XmStringCreateLtoR(buf, font);
	}
	XtVaSetValues(m->list,
		XmNitems,	strings,
		XmNitemCount,	m->dsc->n_pages,
		NULL);
	if(m->page >= 0)
		XmListSelectPos(m->list, m->page + 1, False);

	for(i = 0; i < m->dsc->n_pages; ++i)
		XmStringFree(strings[i]);
	XtFree((XtPointer)strings);
	mgv_sens(m->main, m->sens);
}
