/*
 * window.c
 *	Window and popup menu callbacks for mgv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#include <wlib/rcs.h>
MU_ID("$Mu: mgv/window.c,v 1.31 $")

#include <assert.h>
#include <Xm/ToggleB.h>

#include <wlib/wlib.h>
#include <wlib/typesanity.h>
#include <wlib/log.h>
#include <mine/mgv.h>
#include <mine/strings.h>
#include <mine/window.h>
#include <mine/zoom.h>

/*
 * window->hide log, popup->hide log
 */
void
mgv_window_log(Widget w, XtPointer closure, XtPointer call)
{
	XmTBS	*cbs = (XmTBS *)call;
	MGV	*m   = (MGV *)closure;
	USEUP(w);
	assert(MgvOK(m));

	if(cbs->set)
		m->bits |= MgvHIDELOG;
	else
		m->bits &= ~MgvHIDELOG;
	if(m->log != NULL)
		wl_log_show(m->log, !cbs->set);
}

/*
 * hide/unhide the page list
 */
void
mgv_window_page(Widget w, XtPointer closure, XtPointer call)
{
	XmTBS	*cbs = (XmTBS *)call;
	MGV	*m   = (MGV *)closure;
	assert(MgvOK(m));

	if(cbs->set) {
		XtVaSetValues(m->sw,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);
		XtUnmanageChild(XtParent(m->list));
	}
	else {
		if(!m->labels && !m->pgnums) {
			w = wl_find1(m->main, "*menuBar*page_pd*showPgNums");
			XmToggleButtonSetState(w, True, True);
		}
		XtManageChild(XtParent(m->list));
		XtVaSetValues(m->sw,
			XmNrightAttachment,	XmATTACH_WIDGET,
			XmNrightWidget,		XtParent(m->list),
			NULL);
	}

	m->autosizer(m);
}


/*
 * hide/unhide the status line
 */
void
mgv_window_status(Widget w, XtPointer closure, XtPointer call)
{
	XmTBS		*cbs = (XmTBS *)call;
	MGV		*m   = (MGV *)closure;
	Arg		a[2];
	Cardinal	n;
	Widget		status;
	USEUP(w);
	assert(MgvOK(m));

	n = 0;
	status = wl_find1(m->main, "*statusLine");
	if(cbs->set) {
		XtSetArg(a[n], XmNbottomAttachment, XmATTACH_FORM);	++n;
		assert(ARGSANITY(a, n));
		XtSetValues(m->sw,		&a[0], n);
		XtSetValues(XtParent(m->list),	&a[0], n);
		XtUnmanageChild(status);
	}
	else {
		XtManageChild(status);
		XtSetArg(a[n], XmNbottomAttachment, XmATTACH_WIDGET);	++n;
		XtSetArg(a[n], XmNbottomWidget,     status);		++n;
		assert(ARGSANITY(a, n));
		XtSetValues(m->sw,		&a[0], n);
		XtSetValues(XtParent(m->list),	&a[0], n);
	}

	m->autosizer(m);
}

/*
 * Hide/unhide the menu bar, we don't manage/unmanage because we
 * don't want to lose the accelerators.
 */
void
mgv_window_menu(Widget w, XtPointer closure, XtPointer call)
{
	XmTBS		*cbs = (XmTBS *)call;
	MGV		*m   = (MGV *)closure;
	Arg		a[2];
	Cardinal	n;
	Widget		menubar;
	USEUP(w);
	assert(MgvOK(m));

	n = 0;
	menubar = wl_find1(m->main, "*menuBar");
	if(cbs->set) {
		if(!(m->bits & MgvMENUDOWN)) {
			XtWidgetGeometry	request;
			XtGeometryResult	status;

			/*
			 * Down on your knees rebel dog!
			 */
			memset((void *)&request, '\0', sizeof(request));
			request.request_mode = CWStackMode;
			request.stack_mode   = Below;
			status = XtMakeGeometryRequest(menubar, &request, NULL);
			if(status != XtGeometryYes) {
				wl_warn(w, "%s", mgv_s(w, MgvScantHideMenu));
				XmToggleButtonSetState(w, False, False);
				return;
			}
			m->bits |= MgvMENUDOWN;
		}

		XtSetArg(a[n], XmNtopAttachment, XmATTACH_FORM);	++n;
	}
	else {
		XtSetArg(a[n], XmNtopAttachment, XmATTACH_WIDGET);	++n;
		XtSetArg(a[n], XmNtopWidget,     menubar);		++n;
	}
	assert(ARGSANITY(a, n));
	XtSetValues(m->sw,             &a[0], n);
	XtSetValues(XtParent(m->list), &a[0], n);

	m->autosizer(m);
}

/*
 * window->close zooms, popup->close zooms
 */
void
mgv_window_zoom(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	mgv_zoom_killall(m);
}
