/*
 * wlib.h
 *	Interface to wlib.
 *
 * Copyright (C) 1996 Matthew D. Francey
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#ifndef	WLIB_H
#define	WLIB_H
MU_HID(wlib_h, "$Mu: wlib/wlib/wlib.h,v 1.42 $")

#include <X11/Intrinsic.h>

#include <wlib/strdefs.h>

/*
 * widget creation convenience function
 */
CDECLS_BEGIN
typedef Widget (*WL_CONVFUNC)(Widget, String, ArgList, Cardinal);
CDECLS_END

#define	WL_DIRECT	0
#define	WL_INDIRECT	(1 << 0)
#define	WL_STRINGXM	(1 << 1)

/*
 * callback lists
 */
typedef struct {
	char		*name;
	char		*call;
	int		type;
	XtPointer	closure;
	void		(*func)(Widget, XtPointer, XtPointer);
} WLC;

/*
 * widget lists
 * in most cases, the "type" will be the name of the widget's public
 * header (without the .h), for dialogs, use "ErrorDialog", "FileSBDialog",...
 * if you've added a widget, then you already know what "type" to use
 *
 * For convenience (and some extra compile time checking), constants
 * for the standard Motif 1.2 classes are provided below
 */
#define	WL_MANAGE	(1 << 0)
#define	WL_UNMANAGE	(1 << 1)
typedef struct wl_widget_s WLW;
struct wl_widget_s {
	char	*name;
	char	*type;
	int	flags;	/* WL_MANAGE, WL_UNMANAGE */
	WLW	*kids;
};

/*
 * these currently only exists for completeness
 */
#define	wl_find1	XtNameToWidget
#define	wl_destroy	XtDestroyWidget

/*
 * Values struct for wl_[gs]etsbvalues().  You can deal with most
 * of this stuff with XmScrollBar[GS]etValues() but you can't get/set
 * XmNminimum or XmNmaxiumum (and you'll almost always want the bounds
 * to ensure sanity on the slider position).
 */
typedef struct {
	int	value;		/* slider position			*/
	int	slider;		/* slider size				*/
	int	incr;		/* increment/decrement amount		*/
	int	pincr;		/* page increment/decrement amount	*/
	int	max;		/* XmNmaximum				*/
	int	min;		/* XmNminimum				*/
} WL_SBV;

/*
 * prototypes
 * Functions that return ints generally return zero for success
 * and an errno value for failure
 */
CDECLS_BEGIN
extern	Display *wl_init(int *argc, char **argv, String cls,
			XrmOptionDescList opt, Cardinal nopt, char **fallbacks);
extern	XtAppContext wl_app(void);

/*
 * this returns an errno value on failure and zero on success
 */
extern	int	wl_addclass(char *type, WidgetClass cls, WL_CONVFUNC func,
								int dlg);
extern	int	wl_appnames(Widget, char *, int, char *, int);
extern	char	*wl_appname(Widget, char *, int);
extern	char	*wl_appclass(Widget, char *, int);
extern	Widget	wl_create(Widget parent, WLW *tree);
extern	void	wl_dismiss(Widget w, XtPointer closure, XtPointer call);
extern	void	wl_callback(Widget top, WLC *callbacks, XtPointer closure);
extern	Widget	wl_error(Widget parent, char *fmt, ...);
extern	Widget	wl_warn(Widget parent, char *fmt, ...);
extern	Widget	wl_msg(Widget parent, char *fmt, ...);
extern	void	wl_help(Widget w, XtPointer closure, XtPointer call);
extern	void	wl_help_context(Widget w, XtPointer closure, XtPointer call);
extern	void	wl_find(Widget top, ...);
extern	Widget	wl_findup(Widget w, char *name);
extern	Widget	wl_top(Widget w);
extern	Widget	wl_shell(Widget w);
extern	Widget	wl_focus(Widget w);

extern	Widget	wl_getsbvalues(Widget w, char *name, WL_SBV *v);
extern	void	wl_setsbvalues(Widget w, WL_SBV *v, Boolean notify);

extern	char	*wl_version(char *buf);

extern	void	wl_toggle_sync(Widget, XtPointer, XtPointer);

extern	int	wl_chkver(Widget);

extern	void	wl_dlg_popup(Widget);
extern	void	wl_dlg_popdown(Widget);

CDECLS_END

#endif
