/*
 * wlibP.h
 *	Private wlib routines.
 *
 * Copyright (C) 1996  Matthew D. Francey
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#ifndef	WLIBP_H
#define	WLIBP_H
MU_HID(wlibP_h, "$Mu: wlib/wlib/wlibP.h,v 1.25 $")

#include	<stdio.h>

/*
 * Internal String resources.
 */
enum {
	WlpShelpBrowser,
	WlpShelpPrefix,
	WlpScantGet,
	WlpSemptyLog,
	WlpScantBrowse,
	WlpSnotSupported,
	WlpSbadVersion,
	WlpSunknown
};

typedef struct {
	String	chapter;
	String	section;
} WLP_HELP;

CDECLS_BEGIN

/*
 * Remember that "w" might be a Gadget so you should probably use
 * "XtDisplay(wl_top(w))" if you need to get a Display.
 */
typedef	Boolean	(*WL_HELPFN)(Widget w, WLP_HELP *h);

extern	Boolean	wlp_help_html(Widget, WLP_HELP *);
extern	Boolean	wlp_help_remote(Widget, WLP_HELP *);
extern	Boolean	wlp_help_cci(Widget, WLP_HELP *);
extern	Boolean	wlp_help_libhelp(Widget, WLP_HELP *);

/*
 * string loader
 */
extern	char	*wlp_s(Widget w, int id);

/*
 * socket hiders
 */
extern	FILE	*wlp_sopen(char *name, char *mode);
extern	int	 wlp_sclose(FILE *fp);
extern	size_t	 wlp_sread(void *buf, size_t size, size_t n, FILE *fp);
extern	size_t	 wlp_swrite(void *buf, size_t size, size_t n, FILE *fp);
extern	char	*wlp_sgets(char *s, int n, FILE *fp);
extern	int	 wlp_sprintf(FILE *fp, char *fmt, ...);

CDECLS_END

#endif
