/*
 * xgifroot.c - displays GIF pictures on an X11 root window
 *
 *  Author:    Bob Paauwe, Intel Corp.  (bpaauwe@mcdre3.intel.com)
 *
 *  This is a hacked version of John Bradley's xgif program.  I 
 *  removed all the stuff to display the image in a window and added
 *  the code to make it become the root window background.  All the
 *  code for reading and converting the GIF image is John's
 *
 *  xgif: John Bradly, University of Pennsylvania  (bradley@cis.upenn.edu)
 */

#define MAIN
#include <X11/Xatom.h>
#include "xgif.h"


/*******************************************/
main(argc, argv)
    int   argc;
    char *argv[];
/*******************************************/
{
    int        i;
    char      *display, *geom, *fname;
    XEvent     event;

    cmd = argv[0];
    display = geom = fname = NULL;
    expImage = NULL;
    dispImage = NULL;

    expand = 1;  strip = 0;  nostrip = 0; 
    pausetime = 0;

    /*********************Options*********************/

    for (i = 1; i < argc; i++) {
        char *strind;

        if (!strncmp(argv[i],"-d",2)) {                /* display */
            i++;
            display = argv[i];
            continue;
            }

        strind = index(argv[i], ':');          /* old-style display */
        if(strind != NULL) {
            display = argv[i];
            continue;
            }

        if (argv[i][0] != '-') {               /* the file name */
            fname = argv[i];
            continue;
            }

        Syntax(cmd);
    }

    if (fname==NULL) fname="-";

    /*****************************************************/

    /* Open up the display. */

    if ( (theDisp=XOpenDisplay(display)) == NULL) {
        fprintf(stderr, "%s: Can't open display\n",argv[0]);
        exit(1);
        }

    theScreen = DefaultScreen(theDisp);
    theCmap   = DefaultColormap(theDisp, theScreen);
    rootW     = RootWindow(theDisp,theScreen);
    theGC     = DefaultGC(theDisp,theScreen);
    fcol      = WhitePixel(theDisp,theScreen);
    bcol      = BlackPixel(theDisp,theScreen);
    theVisual = DefaultVisual(theDisp,theScreen);

    dispcells = DisplayCells(theDisp, theScreen);
    if (dispcells<=2) 
        FatalError("This program requires a color display, pref. 8 bits.");


    /****************** Open/Read the File  *****************/
    LoadGIF(fname);
    iWIDE = theImage->width;  iHIGH = theImage->height;

    eWIDE = DisplayWidth(theDisp,theScreen);
    eHIGH = DisplayHeight(theDisp,theScreen);

    /**************** Draw image *****************/
    Resize(eWIDE,eHIGH);
    DrawWindow ( 0, 0, eWIDE, eHIGH );
}




/***********************************/
Syntax()
{
    printf("Usage: %s filename [[-display] display]\n",cmd);
    exit(1);
}


/***********************************/
FatalError (identifier)
       char *identifier;
{
    fprintf(stderr, "%s: %s\n",cmd, identifier);
    exit(-1);
}


/***********************************/
Quit()
{
    exit(0);
}


/***********************************/
DrawWindow(x,y,w,h)
{
    Pixmap  pic;
    GC         gc;
    XGCValues  gcv;
    Atom               prop, type;
    unsigned char      *data;
    unsigned long      length, after;
    int                        format;

    CheckDepth();
    gcv.foreground = BlackPixel( theDisp, theScreen );
    gcv.background = WhitePixel( theDisp, theScreen );
    gc = XCreateGC ( theDisp, rootW, GCForeground|GCBackground, &gcv );
    pic = XCreatePixmap ( theDisp, rootW, w, h, DefaultDepth(theDisp, theScreen));

    if (pic == 0) {
        fprintf(stderr, "%s: Unable to create Pixmap", cmd);
        exit(1);
        }

    XPutImage(theDisp,pic,gc,expImage,x,y,x,y,w,h);
    XPutImage(theDisp,rootW,gc,expImage,x,y,x,y,w,h);
    XSetWindowBackgroundPixmap(theDisp, rootW, pic);
    XFreeGC(theDisp, gc);
    XFreePixmap(theDisp, pic);
    XClearWindow(theDisp, rootW);
    XFlush(theDisp);

    prop = XInternAtom ( theDisp, "_XSETROOT_ID", False );
    (void) XGetWindowProperty ( theDisp, rootW, prop, 0L, 1L, True, 
               AnyPropertyType, &type, &format, &length, &after, &data );
    if ((type == XA_PIXMAP) && (format == 32) && (length == 1 ) &&
       (after == 0) )
       XKillClient ( theDisp, *((Pixmap *)data) );
    XFlush ( theDisp );

}


/***********************************/
/*  This makes sure the display's depth is the same as the
 * depth of the default 8 bit image.  If not, we build a new image
 * that has the correct depth.  This works on the fact that
 * the color mapper has already changed every pixel value in the
 * image into the proper number of bits (to fit into the pallet)
 * so we can just chop down the number of bits.
 *   This changes the global variable 'expImage' if necessary.
 */
CheckDepth()
{
    register byte *sptr, *dptr;
    register unsigned int pixval;
    register int dwx, dwy;
    byte *ximag;

    if (expImage->depth != DefaultDepth(theDisp, theScreen) ) {
       dispImage = expImage;
       ximag = (byte *) malloc(eWIDE*eHIGH);
        expImage = XCreateImage(theDisp,theVisual,DefaultDepth(theDisp, theScreen),
           ZPixmap,0,ximag,eWIDE,eHIGH,8,0);
       if (dispImage->depth == 8 && expImage->depth == 4) {
           /* speedup for the most common format change */
           dptr = (byte *)expImage->data;
           sptr = (byte *)dispImage->data;
           for (dwy=1; dwy<=eHIGH; dwy++) {
               for (dwx=1; dwx<eWIDE; dwx+=2) {
                   *dptr = (*sptr) | (*(sptr+1)<<4);
                   dptr++;
                   sptr+=2;
               }
               if (eWIDE & 1) {
                   /* if extra pixal at end of line, just move it */
                   *dptr = *sptr;
                   sptr++; dptr++;
               }
           }
       }
       else {
           for (dwx=0; dwx<eWIDE; dwx++) {
               for (dwy=0; dwy<eHIGH; dwy++) {
                   pixval = XGetPixel(dispImage, dwx, dwy);
                   (void) XPutPixel(expImage, dwx, dwy, pixval);
               }
           }
           if (dispImage != theImage) {
                   free(dispImage->data);
                   dispImage->data = NULL;
               XDestroyImage(dispImage);
           }
       }
    }
}

/***********************************/
Resize(w,h)
int w,h;
{
    int  ix,iy,ex,ey;
    byte *ximag,*ilptr,*ipptr,*elptr,*epptr;
    static char *rstr = "Resizing Image.  Please wait...";

    /* warning:  this code'll only run machines where int=32-bits */

    if (w==iWIDE && h==iHIGH) {                /* very special case */
        if (expImage != theImage) {
            if (expImage) XDestroyImage(expImage);
            expImage = theImage;
            eWIDE = iWIDE;  eHIGH = iHIGH;
            }
        }

    else {                             /* have to do some work */
        /* if it's a big image, this'll take a while.  mention it */
        if (w*h>(500*500)) {
           printf ( "%s\n", rstr );
            }

       /* first, kill the old expImage, if one exists */
       if (expImage && expImage != theImage) {
            free(expImage->data);  expImage->data = NULL;
            XDestroyImage(expImage);
            }

        /* create expImage of the appropriate size */
        
        eWIDE = w;  eHIGH = h;
        ximag = (byte *) malloc(w*h);
        expImage = XCreateImage(theDisp,theVisual,8,ZPixmap,0,ximag,
                        eWIDE,eHIGH,8,eWIDE);

        if (!ximag || !expImage) {
            fprintf(stderr,"ERROR: unable to create a %dx%d image\n",w,h);
            exit(0);
            }

        elptr = epptr = (byte *) expImage->data;

        for (ey=0;  ey<eHIGH;  ey++, elptr+=eWIDE) {
            iy = (iHIGH * ey) / eHIGH;
            epptr = elptr;
            ilptr = (byte *) theImage->data + (iy * iWIDE);
            for (ex=0;  ex<eWIDE;  ex++,epptr++) {
                ix = (iWIDE * ex) / eWIDE;
                ipptr = ilptr + ix;
                *epptr = *ipptr;
                }
            }
        }
}
                
