/* $XConsortium: CommandF.c,v 1.79 94/04/17 20:11:58 kaleb Exp $ */

/***********************************************************

Copyright (c) 1987, 1988, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * CommandF.c - CommandF button widget
 */

#define __DEBUG__

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/XawInit.h>
#include "CommandFP.h"
#include <X11/Xmu/Converters.h>
#include <X11/extensions/shape.h>

#define DEFAULT_HIGHLIGHT_THICKNESS 2
#define DEFAULT_SHAPE_HIGHLIGHT 32767

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static char defaultTranslations[] =
    "<EnterWindow>:	highlight()		\n\
     <LeaveWindow>:	reset()			\n\
     <Btn1Down>:	set()			\n\
     <Btn1Up>:		notify() unset()	";

#define offset(field) XtOffsetOf(CommandFRec, field)
static XtResource resources[] = { 
   {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer), 
      offset(commandF.callbacks), XtRCallback, (XtPointer)NULL},
   {XtNhighlightThickness, XtCThickness, XtRDimension, sizeof(Dimension),
      offset(commandF.highlight_thickness), XtRImmediate,
      (XtPointer) DEFAULT_SHAPE_HIGHLIGHT},
   {XtNshapeStyle, XtCShapeStyle, XtRShapeStyle, sizeof(int),
      offset(commandF.shape_style), XtRImmediate, (XtPointer)XawShapeRectangle},
   {XtNcornerRoundPercent, XtCCornerRoundPercent, 
	XtRDimension, sizeof(Dimension),
	offset(commandF.corner_round), XtRImmediate, (XtPointer) 25}
};
#undef offset

static Boolean SetValues();
static void Initialize(), Redisplay(), Set(), Reset(), Notify(), Unset();
static void Highlight(), Unhighlight(), Destroy(), PaintCommandFWidget();
static void ClassInitialize();
static Boolean ShapeButton();
static void Realize(), Resize();

static XtActionsRec actionsList[] = {
  {"set",		Set},
  {"notify",		Notify},
  {"highlight",		Highlight},
  {"reset",		Reset},
  {"unset",		Unset},
  {"unhighlight",	Unhighlight}
};

#define SuperClass ((LabelFWidgetClass)&labelFClassRec)

CommandFClassRec commandFClassRec = {
  {
    (WidgetClass) SuperClass,		/* superclass		  */	
    "CommandF",				/* class_name		  */
    sizeof(CommandFRec),			/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    actionsList,			/* actions		  */
    XtNumber(actionsList),		/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    Resize,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    defaultTranslations,		/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    XtInheritChangeSensitive		/* change_sensitive	*/
  },  /* SimpleClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* LabelFClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* CommandFClass fields initialization */
};

  /* for public consumption */
WidgetClass commandFWidgetClass = (WidgetClass) &commandFClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static GC 
Get_GC(cbw, fg, bg)
CommandFWidget cbw;
Pixel fg, bg;
{
  XGCValues	values;
  
  values.foreground   = fg;
  values.background	= bg;
  values.font		= cbw->labelF.font->fid;
  values.cap_style = CapProjecting;
  
  if (cbw->commandF.highlight_thickness > 1 )
    values.line_width   = cbw->commandF.highlight_thickness;
  else 
    values.line_width   = 0;
  
  if ( cbw->simple.international == True )
      return XtAllocateGC((Widget)cbw, 0, 
		 (GCForeground|GCBackground|GCLineWidth|GCCapStyle),
		 &values, GCFont, 0 );
  else
      return XtGetGC((Widget)cbw,
		 (GCForeground|GCBackground|GCFont|GCLineWidth|GCCapStyle),
		 &values);
}


/* ARGSUSED */
static void 
Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;			/* unused */
Cardinal *num_args;		/* unused */
{
  CommandFWidget cbw = (CommandFWidget) new;
  int shape_event_base, shape_error_base;

  if (cbw->commandF.shape_style != XawShapeRectangle
      && !XShapeQueryExtension(XtDisplay(new), &shape_event_base, 
			       &shape_error_base))
      cbw->commandF.shape_style = XawShapeRectangle;
  if (cbw->commandF.highlight_thickness == DEFAULT_SHAPE_HIGHLIGHT) {
      if (cbw->commandF.shape_style != XawShapeRectangle)
	  cbw->commandF.highlight_thickness = 0;
      else
	  cbw->commandF.highlight_thickness = DEFAULT_HIGHLIGHT_THICKNESS;
  }

  cbw->commandF.normal_GC = Get_GC(cbw, cbw->labelF.foreground, 
				  cbw->core.background_pixel);
  cbw->commandF.inverse_GC = Get_GC(cbw, cbw->core.background_pixel, 
				   cbw->labelF.foreground);
				   
  XtReleaseGC(new, cbw->labelF.normal_GC);
  cbw->labelF.normal_GC = cbw->commandF.normal_GC;

  cbw->commandF.set = FALSE;
  cbw->commandF.highlighted = HighlightNone;
}

static Region 
HighlightRegion(cbw)
CommandFWidget cbw;
{
  static Region outerRegion = NULL, innerRegion, emptyRegion;
  XRectangle rect;

  if (cbw->commandF.highlight_thickness == 0 ||
      cbw->commandF.highlight_thickness >
      (Dimension) ((Dimension) Min(cbw->core.width, cbw->core.height)/2))
    return(NULL);

  if (outerRegion == NULL) {
    /* save time by allocating scratch regions only once. */
    outerRegion = XCreateRegion();
    innerRegion = XCreateRegion();
    emptyRegion = XCreateRegion();
  }

  rect.x = rect.y = 0;
  rect.width = cbw->core.width;
  rect.height = cbw->core.height;
  XUnionRectWithRegion( &rect, emptyRegion, outerRegion );
  rect.x = rect.y = cbw->commandF.highlight_thickness;
  rect.width -= cbw->commandF.highlight_thickness * 2;
  rect.height -= cbw->commandF.highlight_thickness * 2;
  XUnionRectWithRegion( &rect, emptyRegion, innerRegion );
  XSubtractRegion( outerRegion, innerRegion, outerRegion );
  return outerRegion;
}

/***************************
*
*  Action Procedures
*
***************************/

/* ARGSUSED */
static void 
Set(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  CommandFWidget cbw = (CommandFWidget)w;

  if (cbw->commandF.set)
    return;

  cbw->commandF.set= TRUE;
  if (XtIsRealized(w))
    PaintCommandFWidget(w, event, (Region) NULL, TRUE);
}

/* ARGSUSED */
static void
Unset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;
{
  CommandFWidget cbw = (CommandFWidget)w;

  if (!cbw->commandF.set)
    return;

  cbw->commandF.set = FALSE;
  if (XtIsRealized(w)) {
    XClearWindow(XtDisplay(w), XtWindow(w));
    PaintCommandFWidget(w, event, (Region) NULL, TRUE);
  }
}

/* ARGSUSED */
static void 
Reset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;   /* unused */
{
  CommandFWidget cbw = (CommandFWidget)w;

  if (cbw->commandF.set) {
    cbw->commandF.highlighted = HighlightNone;
    Unset(w, event, params, num_params);
  } else
    Unhighlight(w, event, params, num_params);
}

/* ARGSUSED */
static void 
Highlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		
Cardinal *num_params;	
{
  CommandFWidget cbw = (CommandFWidget)w;

  if ( *num_params == (Cardinal) 0) 
    cbw->commandF.highlighted = HighlightWhenUnset;
  else {
    if ( *num_params != (Cardinal) 1) 
      XtWarning("Too many parameters passed to highlight action table.");
    switch (params[0][0]) {
    case 'A':
    case 'a':
      cbw->commandF.highlighted = HighlightAlways;
      break;
    default:
      cbw->commandF.highlighted = HighlightWhenUnset;
      break;
    }
  }

  if (XtIsRealized(w))
    PaintCommandFWidget(w, event, HighlightRegion(cbw), TRUE);
}

/* ARGSUSED */
static void 
Unhighlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  CommandFWidget cbw = (CommandFWidget)w;

  cbw->commandF.highlighted = HighlightNone;
  if (XtIsRealized(w))
    PaintCommandFWidget(w, event, HighlightRegion(cbw), TRUE);
}

/* ARGSUSED */
static void 
Notify(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  CommandFWidget cbw = (CommandFWidget)w; 

  /* check to be sure state is still Set so that user can cancel
     the action (e.g. by moving outside the window, in the default
     bindings.
  */
  if (cbw->commandF.set)
    XtCallCallbackList(w, cbw->commandF.callbacks, (XtPointer) NULL);
}

/*
 * Repaint the widget window
 */

/************************
*
*  REDISPLAY (DRAW)
*
************************/

/* ARGSUSED */
static void 
Redisplay(w, event, region)
Widget w;
XEvent *event;
Region region;
{
  PaintCommandFWidget(w, event, region, FALSE);
}

/*	Function Name: PaintCommandFWidget
 *	Description: Paints the commandF widget.
 *	Arguments: w - the commandF widget.
 *                 region - region to paint (passed to the superclass).
 *                 change - did it change either set or highlight state?
 *	Returns: none
 */

static void 
PaintCommandFWidget(w, event, region, change)
Widget w;
XEvent *event;
Region region;
Boolean change;
{
  CommandFWidget cbw = (CommandFWidget) w;
/*  CommandFWidgetClass cwclass = (CommandFWidgetClass) XtClass (w); */
  Boolean very_thick;
  GC norm_gc, rev_gc;
   
  very_thick = cbw->commandF.highlight_thickness >
               (Dimension)((Dimension) Min(cbw->core.width, cbw->core.height)/2);

  if (cbw->commandF.set) {
    cbw->labelF.normal_GC = cbw->commandF.inverse_GC;
    XFillRectangle(XtDisplay(w), XtWindow(w), cbw->commandF.normal_GC,
		   0, 0, cbw->core.width, cbw->core.height);
    region = NULL;		/* Force labelF to repaint text. */
  }
  else
    cbw->labelF.normal_GC = cbw->commandF.normal_GC;

  if (cbw->commandF.highlight_thickness <= 0)
  {
    (*SuperClass->core_class.expose) (w, event, region);
    return;
  }

/*
 * If we are set then use the same colors as if we are not highlighted. 
 */

  if (cbw->commandF.set == (cbw->commandF.highlighted == HighlightNone)) {
    norm_gc = cbw->commandF.inverse_GC;
    rev_gc = cbw->commandF.normal_GC;
  }
  else {
    norm_gc = cbw->commandF.normal_GC;
    rev_gc = cbw->commandF.inverse_GC;
  }

  if ( !( (!change && (cbw->commandF.highlighted == HighlightNone)) ||
	  ((cbw->commandF.highlighted == HighlightWhenUnset) &&
	   (cbw->commandF.set))) ) {
    if (very_thick) {
      cbw->labelF.normal_GC = norm_gc; /* Give the labelF the right GC. */
      XFillRectangle(XtDisplay(w),XtWindow(w), rev_gc,
		     0, 0, cbw->core.width, cbw->core.height);
    }
    else {
      /* wide lines are centered on the path, so indent it */
      int offset = cbw->commandF.highlight_thickness/2;
      XDrawRectangle(XtDisplay(w),XtWindow(w), rev_gc, offset, offset, 
		     cbw->core.width - cbw->commandF.highlight_thickness,
		     cbw->core.height - cbw->commandF.highlight_thickness);
    }
  }
  (*SuperClass->core_class.expose) (w, event, region);
}

static void 
Destroy(w)
Widget w;
{
  CommandFWidget cbw = (CommandFWidget) w;

  /* so LabelF can release it */
  if (cbw->labelF.normal_GC == cbw->commandF.normal_GC)
    XtReleaseGC( w, cbw->commandF.inverse_GC );
  else
    XtReleaseGC( w, cbw->commandF.normal_GC );
}

/*
 * Set specified arguments into widget
 */

/* ARGSUSED */
static Boolean 
SetValues (current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
  CommandFWidget oldcbw = (CommandFWidget) current;
  CommandFWidget cbw = (CommandFWidget) new;
  Boolean redisplay = False;

  if ( oldcbw->core.sensitive != cbw->core.sensitive && !cbw->core.sensitive) {
    /* about to become insensitive */
    cbw->commandF.set = FALSE;
    cbw->commandF.highlighted = HighlightNone;
    redisplay = TRUE;
  }
  
  if ( (oldcbw->labelF.foreground != cbw->labelF.foreground)           ||
       (oldcbw->core.background_pixel != cbw->core.background_pixel) ||
       (oldcbw->commandF.highlight_thickness != 
                                   cbw->commandF.highlight_thickness) ||
       (oldcbw->labelF.font != cbw->labelF.font) ) 
  {
    if (oldcbw->labelF.normal_GC == oldcbw->commandF.normal_GC)
	/* LabelF has release one of these */
      XtReleaseGC(new, cbw->commandF.inverse_GC);
    else
      XtReleaseGC(new, cbw->commandF.normal_GC);

    cbw->commandF.normal_GC = Get_GC(cbw, cbw->labelF.foreground, 
				    cbw->core.background_pixel);
    cbw->commandF.inverse_GC = Get_GC(cbw, cbw->core.background_pixel, 
				     cbw->labelF.foreground);
    XtReleaseGC(new, cbw->labelF.normal_GC);
    cbw->labelF.normal_GC = (cbw->commandF.set
			    ? cbw->commandF.inverse_GC
			    : cbw->commandF.normal_GC);
    
    redisplay = True;
  }

  if ( XtIsRealized(new)
       && oldcbw->commandF.shape_style != cbw->commandF.shape_style
       && !ShapeButton(cbw, TRUE))
  {
      cbw->commandF.shape_style = oldcbw->commandF.shape_style;
  }

  return (redisplay);
}

static void ClassInitialize()
{
    XawInitializeWidgetSet();
    XtSetTypeConverter( XtRString, XtRShapeStyle, XmuCvtStringToShapeStyle,
		        (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL );
}


static Boolean
ShapeButton(cbw, checkRectangular)
CommandFWidget cbw;
Boolean checkRectangular;
{
    Dimension corner_size;

    if ( (cbw->commandF.shape_style == XawShapeRoundedRectangle) ) {
	corner_size = (cbw->core.width < cbw->core.height) ? cbw->core.width 
	                                                   : cbw->core.height;
	corner_size = (int) (corner_size * cbw->commandF.corner_round) / 100;
    }

    if (checkRectangular || cbw->commandF.shape_style != XawShapeRectangle) {
	if (!XmuReshapeWidget((Widget) cbw, cbw->commandF.shape_style,
			      corner_size, corner_size)) {
	    cbw->commandF.shape_style = XawShapeRectangle;
	    return(False);
	}
    }
    return(TRUE);
}

static void Realize(w, valueMask, attributes)
    Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    (*commandFWidgetClass->core_class.superclass->core_class.realize)
	(w, valueMask, attributes);

    ShapeButton( (CommandFWidget) w, FALSE);
}

static void Resize(w)
    Widget w;
{
    if (XtIsRealized(w)) 
	ShapeButton( (CommandFWidget) w, FALSE);

    (*commandFWidgetClass->core_class.superclass->core_class.resize)(w);
}
