#include <stdio.h>
#include <stdlib.h>
#include "file_types.h"
#include "globals.h"
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#include "mini-ofolder.xpm"

#define FB_COMMAND "cat /dev/null | fb"

Pixmap *FolderPfolder=NULL;
Pixmap *FolderPshape=NULL;
XpmAttributes *FolderPattrib=NULL;

int isFolder1(char *filename)
{
struct stat buf;

stat(filename,&buf);
return S_ISDIR(buf.st_mode);
}

int isFolder(char *filename)
{
DIR *d;

d=opendir(filename);
if(d==NULL){ 
     if(errno==ENOTDIR)return 0;
     return 1;
    }
closedir(d);
return 1;
}

char __DIR[2000];
Pixmap *Recognize_Folder(char *filename,char *dpname)
{

if(!isFolder(dpname))return NULL;
FolderPfolder=calloc(1,sizeof(Pixmap));
FolderPshape=calloc(1,sizeof(Pixmap));
FolderPattrib=calloc(1,sizeof(XpmAttributes));

sprintf(__DIR,"%s/.xpm",dpname);

if(XpmReadFileToPixmap(display,root,__DIR,
                        FolderPfolder,
                        FolderPshape,
                        FolderPattrib)!=0){
   XpmCreatePixmapFromData(display,root,ofolder,FolderPfolder,FolderPshape,FolderPattrib);
   }
return FolderPfolder;
}

void Folder_CallBack(char *filename)
{
char *command=NULL;


#ifdef __DEBUG__
fprintf(stdout,"%s\n",filename);
#endif
/* new_window(filename,filename,0); */

(void *)command=calloc(strlen(FB_COMMAND)+strlen(filename)+20,sizeof(char));
if(command==NULL)return;
command[0]=0;
sprintf(command,"%s \"%s\" >& /dev/null &",FB_COMMAND,filename);

system(command);
free(command);

}

void Register_Folder(void)
{
struct Pattern *p;



p=NULL;
(void *)p=calloc(1,sizeof(struct Pattern));
if(p==NULL){
  perror("type_Folder.Register_Folder()");
  exit(-1);
  }
 p->R_P=& Recognize_Folder;
 p->C_B=& Folder_CallBack;
 p->data=NULL;
 

RegisterPattern(p);
}


