/*
 * Copyright 1996, John Crowe.  (crowej@eecs.umich.edu)
 *   Permission to use, copy, modify, and distribute this software   
 *   and its documentation for any purpose and without fee is hereby
 *   granted, provided that the above copyright notice appear in all
 *   copies and that both that copyright notice and this permission
 *   notice appear in supporting documentation.  This software is
 *   provided "as is" without express or implied warranty.
 */
/* --------------------------------------------------------------- */
/*
*   Returns a handle to a 2 dimensional array of size w by h where
*   each element is size bytes.  
*     J. Crowe 8/93, No guarantees
*
*   usage:
*       int **tst;
*       tst = (int **)calloc2d(w,h,sizeof(int));
*       tst[x][y] = blah blah blah
*       
*       0<= x <w and 0<= y < h
*
*   example:
*       #include <stdio.h>
*       void **calloc2d();
*       main ()
*       {
*         int x, y, i, **tst;
*         tst = (int **)calloc2d(10, 10, sizeof(int));
*         for(x=0; x<10; x++)
*         for(y=0; y<10; y++)
*           tst[x][y]=x*10+y;
*         for(x=0; x<10; x++)
*           for(y=0; y<10; y++)
*             printf("tst[%i][%i]=%i\n", x,y,tst[x][y]);
*         return(0);
*/  
/* --------------------------------------------------------------- */
#include <memory.h>
#include <malloc.h>

void **Calloc2d(nrows,ncols,size)
     int nrows, ncols, size;
{
  char **handle;
  char *temp;
  int i;

  if ((temp = (char *) calloc (nrows*ncols, size)) == 0)
    return((void **)0);

  if ((handle = (char **) malloc (nrows*sizeof(char *))) == 0)
    return((void **)0);

  for(i=0; i<nrows; i++)
      handle[i] = &temp[ncols*i*size];

  return((void **)handle);
}


