/*
 * Endian.c
 *
 * Tests for endian-ness
 *
 *  5/95  J. Crowe
 *   
 * No guarantees, J. Crowe
 */

int WhichEndian();
int BigEndian();
int LittleEndian();


#include <stdio.h>

#define MAIN1

/*
 * WhichEndian.c
 
 * returns 1 if Big Endian  ( MSB LSB )
 * returns 0 if Little Endian ( LSB MSB )
 */
int WhichEndian()
{
  unsigned short i;
  
  i=0x01;  
  return( ( (int) *(char *)(&i) == 0) );
}

/*
 * LittleEndian.c
 
 * returns 0 if Big Endian  ( MSB LSB )
 * returns 1 if Little Endian ( LSB MSB )
 */
int LittleEndian()
{
  return( WhichEndian() == 0 );
}

/*
 * BigEndian.c
 
 * returns 1 if Big Endian  ( MSB LSB )
 * returns 0 if Little Endian ( LSB MSB )
 */
int BigEndian()
{
  return( WhichEndian() );
}

#ifdef MAIN
main(int argc, char **argv)
{
  if(argc>1)
    {
      printf("WhichEndian() returned %d\n", WhichEndian());
      printf("LittleEndian() returned %d\n", LittleEndian());
      printf("BigEndian() returned %d\n", BigEndian());
    }
  return(WhichEndian());
    
}
#endif
