#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "jpeglib.h"

ReadJPEG(FILE *fh_in, unsigned char ***image, int *image_height, int *image_width, int *bytespp)
{
  int i;
  JSAMPLE **buff;
  int erc;
  unsigned char **img;
  int ih;

  struct jpeg_decompress_struct cinfo;
  struct jpeg_error_mgr jerr;

  cinfo.err = jpeg_std_error(&jerr);
  jpeg_create_decompress(&cinfo);

  jpeg_stdio_src(&cinfo, fh_in);

  jpeg_read_header(&cinfo, TRUE);

  cinfo.out_color_space = 
    ((JCS_GRAYSCALE==cinfo.jpeg_color_space)? JCS_GRAYSCALE : JCS_RGB);

  *bytespp = ((JCS_GRAYSCALE==cinfo.out_color_space) ? 1 : 3);

  jpeg_start_decompress(&cinfo);

  buff=(JSAMPLE **)Calloc2d(1, (*bytespp)*cinfo.output_width, sizeof(JSAMPLE));

  

  *image=(unsigned char **)Calloc2d(cinfo.output_height,
				    (*bytespp)*cinfo.output_width,
				    sizeof(unsigned char));
  *image_height=cinfo.output_height;
  *image_width=cinfo.output_width;
  img=(JSAMPLE **)*image;
  
  ih=0;
  while(cinfo.output_scanline < cinfo.output_height)
    {
      
      jpeg_read_scanlines(&cinfo, buff, 1);

      memcpy(img[ih], buff[0], (*bytespp)*cinfo.output_width);
      ih++;
    }
 
  jpeg_finish_decompress(&cinfo);

  jpeg_destroy_decompress(&cinfo);

  Free2d(buff);
  
  return(0);

}
