#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "png.h"

ReadPNG(FILE *fh_in, unsigned char ***image, int *image_height, int *image_width, int *bytespp)
{
  int i;
  int erc;
  unsigned char **img;
  int ih;
  unsigned char **data;


  png_structp png_ptr;
  png_infop info_ptr;
  png_infop end_info;
  png_bytep *row_pointers;


  png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING,
				   NULL, NULL, NULL);
  /*(void *)user_error_ptr,
    user_error_fn, user_warning_fn);
    */
  if (!png_ptr)
    return -1;   /* failure */
  
  info_ptr=png_create_info_struct(png_ptr);

  if(!info_ptr)
    {
      png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
      return -1; /* failure */
    }

  end_info=png_create_info_struct(png_ptr);
  if (!end_info)
    {
      png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      return -1; /* failure */
    }

  png_init_io(png_ptr, fh_in);

  /* get info/header */
  png_read_info(png_ptr, info_ptr);

  *image_width=info_ptr->width;
  *image_height=info_ptr->height;
  *bytespp=info_ptr->rowbytes/info_ptr->width;

  /* If paletted image, expand as RGB */
  if (info_ptr->color_type == PNG_COLOR_TYPE_PALETTE &&
      info_ptr->bit_depth < 8)
    png_set_expand(png_ptr);

  /* If grayscale and less than 8bpp, then expand to 8bpp */
  if (info_ptr->color_type == PNG_COLOR_TYPE_GRAY &&
      info_ptr->bit_depth < 8)
    png_set_expand(png_ptr);

  /* I want data as one byte each of R , G, B */
  if (info_ptr->bit_depth == 16)
    png_set_strip_16(png_ptr);

  if (info_ptr->bit_depth < 8)
    png_set_packing(png_ptr);


   data=(unsigned char **)Calloc2d(*image_height, *image_width*(*bytespp),
		 sizeof(unsigned char));
   
   row_pointers=(png_bytep *)malloc((*image_height)*sizeof(png_bytep *));
   for(i = 0; i<*image_height; i++)
     row_pointers[i] = data[i];

   png_read_image(png_ptr, row_pointers);

   *image=data;
   return 0;
   
}
