typedef struct {
	char *data;
	int ht;
	int wid;
}  vga_bitmap;

/*
 * Args to vga_tile()

 1 - A pointer to a vga_bitmap type
 2 - The x position (top left corner) of the bitmap
 3 - The y position (top left corner) of the bitmap
 4 - The width of the tiling region
 5 - The height of the tiling region


 o      If the height or width of the tiling region is negative the the
	exact image size is placed with the top left hand corner at (x, y).
	This way you can place a bitmap at a certain position on the screen.

 */

void vga_tile(vga_bitmap *, int, int, int, int);

/*
 * Args to loadxpm()/loadxbm()

 1 - The file name of the XPM image
 2 - A pointer to a vga_bitmap type.

 Notes:
 o      If you pass a file that doesnt exist then the default XPM image
	"linux.xpm" will be loaded.

 */
void loadxpm (char *, vga_bitmap *);
void loadxbm (char *, vga_bitmap *);
void loadxbmfromdata (char *, int, int, vga_bitmap *);
void vga_loaddefaultbitmaps(void);
extern vga_bitmap left_bm, right_bm, next_bm, prev_bm;
