#ifndef _VGA_MISCUTILS_H
#define _VGA_MISCUTILS_H 1

#ifndef _VGA_FONTUTILS_H
#include "fontutils.h"
#endif

typedef struct {
	int x;
	int y;
	int wid;
	int ht;
	char *data;
} vga_win;

#define MAXPROMPT		256

#define PROMPT_SCROLLABLE	0	/* Prompt can scroll - default */
#define PROMPT_FIXED		1	/* Prompt can't scroll */
#define PROMPT_NOINPUT		2	/* No Input - just a message */

#define PROMPT_NOECHO		3	/* For forms only - specifies the
					   entry that doesn't echo - like
					   for example Password entries */
/* Args to vga_message()

	1 - The x position of placement (top left)
	2 - The y position of placement (top left)
	3 - The width of the message box
	4 - The height of the message box
	5 - The text of your message
	6 - The filled in font struct pointer returned from the vga_initfont()
	7 - The foreground drawing color
	8 - The background drawing color
	9 - Text time in seconds to keep up the message. The message will
	    cleared and the background restored. If however the time is 0
	    the message is left up there forever and control returned to the
	    calling routine.

   Returns 1 if succeeded 0 if it failed.
   Note: this is infact just a wrapper around the vga_prompt() routine.

 */
#define vga_message(x, y, ht, wid, message, font, fg, bg, seconds) \
		vga_prompt (x, y, ht, wid, \
		message, font, NULL, fg, (short)NULL, bg, \
		(seconds<<2)|PROMPT_NOINPUT);


/* Args to vga_prompt()

	1 - The x position of placement (top left)
	2 - The y position of placement (top left)
	3 - The width of the message box
	4 - The height of the message box
	5 - The text of your message (non editable)
	6 - The filled in prompt font struct pointer returned from the vga_initfont()
	7 - The filled in input font struct pointer returned from the vga_initfont()
	8 - The foreground drawing color of the prompt 
	9 - The foreground drawing color of the input field
       10 - The background drawing color
       11 - This must be one of

		PROMPT_SCROLLABLE	- Prompt can scroll - the default
		PROMPT_FIXED		- Prompt can't scroll

   If PROMPT_FIXED is selected, you must calculate the correct width for your
   box as no more characters than the message+input text is allowed to be
   entered by the user.

   Returns 1 if succeeded 0 if it failed.

 */
char * vga_prompt (short, short, short, short,
	    char *, font_t *, font_t *, short, short, short, unsigned char);


/* Args to vga_form()

	1 - The x position of placement (top left)
	2 - The y position of placement (top left)
	3 - The width of the form box
	4 - The height of the form box
	5 - The array of pointers for the prompt fields
	6 - The array of pointers for the reply fields
	7 - The number of fields in this form
	8 - The title of this form (or NULL if no title required)
	9 - The font to use for drawing the title (or NULL)
       10 - The filled in prompt font struct pointer returned from the vga_initfont()
       11 - The filled in input font struct pointer returned from the vga_initfont()
       12 - The active prompt text drawing color
       13 - The inactive prompt text drawing color
       14 - The input text drawing color
       15 - The background drawing color
       16 - The callback function for the form
       17 - Any extra options as an array for each field. This should be one
	    or more of the following or'ed together.

		PROMPT_SCROLLABLE	- Prompt can scroll - the default
		PROMPT_FIXED		- Prompt can't scroll
		PROMPT_NOECHO		- Prompt doesn't echo (*) is printed

   If PROMPT_FIXED is selected, you must calculate the correct width for your
   box as no more characters than the message+input test is allowed to be
   entered by the user.

   If PROMPT_NOECHO is selected then no output wil be echoed. This is only
   useful really for "password" type entries.

   Notes:
	o	In field 5, the user must provide necessary padding if the
		input fields are required to be aligned properly.

	o	In field 6, the routine vga_form() allocates necessary space
		for the user reply. It is the callers responsibility to free
		the allocated space after he/she has finished with it.

	o	Fields 8,9 may be NULL if you don't require a title.

	o	Field 12,13 specifies the active and inactive colors for the
		prompts such that when the <TAB> key is pressed then fields
		are made active in cyclic manner.

	o	Field 14 is the color of the user input text.

	o	Field 15 is the overall background color of the form.

	o	Field 16 is a user function which will be passed the number
		of the current field and its input text such that intermediate
		processing may be carried out when switching between fields
		with the <RETURN> or <TAB> keys. May be NULL if you don't have
		special requirements. If defined, then the user function should
		be defined as returning an "int" and taking two arguments
		"int" and "char *". Something like

			int usercallback (int field_num, char *field_arg)

		The user function should currently only return one of the
		following, 

			FIELD_OK
			FIELD_STAY
			FIELD_CLEAR

		If FIELD_OK is returned, then the form is allowed to continue
		to the next field or the form terminates if on the last field
		and the <RETURN> key has been pressed.

		If FIELD_STAY is returned, then the form stays on the current
		field.

		If FIELD_CLEAR is returned, then the form stays on the current
		field and it is cleared of the former input.

	o	Field 17 is an array of chars specifying any other options
		for each field which may be or'ed together. May be NULL if you
		don't have special requirements.

   Returns nothing (except in the reply fields)
*/

#define FIELD_OK	0
#define FIELD_STAY	1
#define FIELD_CLEAR	2

void
vga_form(short, short, short, short,
	 char **, char **, int, char *, font_t *, font_t *, font_t *,
	 char, char, char, char, int (), char *);


/* Args to vga_form()

	1 - The x position of placement (top left)
	2 - The y position of placement (top left)
	3 - The width of the multi line message box
	4 - The height of the multi line message box
	5 - The foreground text color of the message
	6 - The background text color of the message
	7 - The multi line text to be displayed
	8 - A title. Can be NULL for no title

   Notes:
	o	The text of the message is truncated to fit the box.
		It is the users responsibility to make the correct provisions
		for their message.

   Returns nothing

*/
void
vga_showmultiline (int x, int y,
		   int wid, int ht,
		   int fg, int bg,
		   const char *text[],
		   const char *title);

#define FILLED	(1<<0)
#define HOLLOW	(1<<1)
#define SUNKEN	(1<<2)
#define RAISED	(1<<3)
#define BOXED	(1<<4)

void vga_drawbox(int x, int y, int wid, int ht, int color, char flags);

#endif /* _VGA_MISCUTILS_H */
